/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationModeAction
extends SimpleButtonAction {
    private LocationMode mode;
    private int count = 0;
    private DockActionIcon iconListener;
    private PropertyValue<KeyStroke> stroke;
    private DockActionText text;
    private DockActionText tooltip;
    private DockController controller;

    public LocationModeAction(DockController controller, LocationMode mode, String iconKey, String textKey, String tooltipKey, PropertyKey<KeyStroke> gotoStroke) {
        if (mode == null) {
            throw new NullPointerException("mode is null");
        }
        if (iconKey == null) {
            throw new NullPointerException("iconKey is null");
        }
        if (gotoStroke == null) {
            throw new NullPointerException("gotoStroke is null");
        }
        this.mode = mode;
        this.stroke = new PropertyValue<KeyStroke>(gotoStroke){

            protected void valueChanged(KeyStroke oldValue, KeyStroke newValue) {
                LocationModeAction.this.setAccelerator(newValue);
            }
        };
        this.iconListener = new DockActionIcon(iconKey, (DockAction)this){

            protected void changed(Icon oldValue, Icon newValue) {
                LocationModeAction.this.setIcon(newValue);
            }
        };
        this.text = new DockActionText(textKey, (DockAction)this){

            protected void changed(String oldValue, String newValue) {
                LocationModeAction.this.setText(newValue);
            }
        };
        this.tooltip = new DockActionText(tooltipKey, (DockAction)this){

            protected void changed(String oldValue, String newValue) {
                LocationModeAction.this.setTooltip(newValue);
            }
        };
        this.setController(controller);
    }

    public void action(Dockable dockable) {
        super.action(dockable);
        LocationModeManager<?> manager = this.mode.getManager();
        while (dockable != null) {
            if (manager.isRegistered(dockable)) {
                manager.apply(dockable, this.mode.getUniqueIdentifier(), false);
                return;
            }
            DockStation station = dockable.asDockStation();
            if (station == null) {
                return;
            }
            dockable = station.getFrontDockable();
        }
    }

    protected void setController(DockController controller) {
        if (this.count > 0) {
            this.connect(this.controller, controller);
        }
        this.controller = controller;
    }

    private void connect(DockController oldController, DockController newController) {
        this.stroke.setProperties(newController);
        this.iconListener.setController(newController);
        this.text.setController(newController);
        this.tooltip.setController(newController);
    }

    protected DockController getController() {
        return this.controller;
    }

    protected boolean checkTrigger(KeyEvent event) {
        return true;
    }

    protected void bound(Dockable dockable) {
        super.bound(dockable);
        if (this.count == 0) {
            this.connect(null, this.controller);
        }
        ++this.count;
    }

    protected void unbound(Dockable dockable) {
        super.unbound(dockable);
        --this.count;
        if (this.count == 0) {
            this.connect(this.controller, null);
        }
    }
}

