/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom;

import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class OdfContainerElementBase
extends OdfElement {
    private static final long serialVersionUID = 6944696143015713668L;

    public OdfContainerElementBase(OdfFileDom ownerDocument, String namespaceURI, String qualifiedName) throws DOMException {
        super(ownerDocument, namespaceURI, qualifiedName);
    }

    public OdfContainerElementBase(OdfFileDom ownerDocument, OdfName aName) throws DOMException {
        super(ownerDocument, aName.getUri(), aName.getQName());
    }

    protected void onOdfNodeInserted(OdfElement node, Node refChild) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void onOdfNodeRemoved(OdfElement node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        Node ret = super.insertBefore(newChild, refChild);
        if (newChild instanceof OdfElement) {
            this.onOdfNodeInserted((OdfElement)((Object)newChild), refChild);
        }
        return ret;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        Node ret = super.removeChild(oldChild);
        if (oldChild instanceof OdfElement) {
            this.onOdfNodeRemoved((OdfElement)((Object)oldChild));
        }
        return ret;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        Node ret = super.replaceChild(newChild, oldChild);
        if (newChild instanceof OdfElement) {
            this.onOdfNodeInserted((OdfElement)((Object)newChild), oldChild);
        }
        if (oldChild instanceof OdfElement) {
            this.onOdfNodeRemoved((OdfElement)((Object)oldChild));
        }
        return ret;
    }
}

