/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.icon;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.AbstractUIScheme;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.icon.DockIconBridge;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIconScheme
extends AbstractUIScheme<Icon, DockIcon, DockIconBridge> {
    private DockController controller;
    private int bound = 0;
    private Map<String, Link> links;

    public AbstractIconScheme(DockController controller) {
        this.controller = controller;
    }

    public void link(PropertyKey<Icon> key, String id) {
        Link link;
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        if ((link = this.links.get(id)) != null) {
            link.setKey(key);
        } else {
            link = new Link(key, id);
            this.links.put(id, link);
            if (this.bound > 0) {
                link.setProperties(this.controller);
            }
        }
    }

    public void unlink(String id) {
        if (this.links != null) {
            Link link = this.links.remove(id);
            if (this.links.isEmpty()) {
                this.links = null;
            }
            if (link != null) {
                link.setProperties((DockProperties)null);
            }
        }
    }

    protected abstract void changed(String var1, Icon var2);

    @Override
    public void install(UIProperties<Icon, DockIcon, DockIconBridge> properties) {
        if (this.bound == 0 && this.links != null) {
            for (Link link : this.links.values()) {
                link.setProperties(this.controller);
            }
        }
        ++this.bound;
    }

    @Override
    public void uninstall(UIProperties<Icon, DockIcon, DockIconBridge> properties) {
        --this.bound;
        if (this.bound == 0 && this.links != null) {
            for (Link link : this.links.values()) {
                link.setProperties((DockProperties)null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Link
    extends PropertyValue<Icon> {
        private String id;

        public Link(PropertyKey<Icon> key, String id) {
            super(key);
            this.id = id;
        }

        @Override
        protected void valueChanged(Icon oldValue, Icon newValue) {
            AbstractIconScheme.this.changed(this.id, newValue);
        }
    }
}

