/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationListener;
import java.util.ArrayList;
import java.util.List;

public class DockStationListenerManager {
    private List<DockStationListener> listeners = new ArrayList<DockStationListener>();
    private DockStation station;

    public DockStationListenerManager(DockStation station) {
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.station = station;
    }

    public DockStation getStation() {
        return this.station;
    }

    public void addListener(DockStationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DockStationListener listener) {
        this.listeners.remove(listener);
    }

    public void fireDockableVisibilitySet(Dockable dockable, boolean value) {
        for (DockStationListener listener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            listener.dockableVisibiltySet(this.station, dockable, value);
        }
    }

    public void fireDockableAdded(Dockable dockable) {
        for (DockStationListener listener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            listener.dockableAdded(this.station, dockable);
        }
    }

    public void fireDockableRemoved(Dockable dockable) {
        for (DockStationListener listener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            listener.dockableRemoved(this.station, dockable);
        }
    }

    public void fireDockableAdding(Dockable dockable) {
        for (DockStationListener listener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            listener.dockableAdding(this.station, dockable);
        }
    }

    public void fireDockableRemoving(Dockable dockable) {
        for (DockStationListener listener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            listener.dockableRemoving(this.station, dockable);
        }
    }

    public void fireDockableSelected(Dockable oldSelected, Dockable newSelected) {
        for (DockStationListener listener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            listener.dockableSelected(this.station, oldSelected, newSelected);
        }
    }

    public void fireDockablesRepositioned(Dockable ... dockables) {
        for (DockStationListener listener : this.listeners.toArray(new DockStationListener[this.listeners.size()])) {
            listener.dockablesRepositioned(this.station, dockables);
        }
    }
}

