/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.office;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.draw.OdfDrawLayerSet;
import org.odftoolkit.odfdom.doc.style.OdfStyleHandoutMaster;
import org.odftoolkit.odfdom.doc.style.OdfStyleMasterPage;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfOfficeMasterStyles
extends OfficeMasterStylesElement {
    private static final long serialVersionUID = 6598785919980862801L;
    private OdfDrawLayerSet mLayerSet;
    private OdfStyleHandoutMaster mHandoutMaster;
    private HashMap<String, OdfStyleMasterPage> mMasterPages;

    public OdfOfficeMasterStyles(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfStyleHandoutMaster getHandoutMaster() {
        return this.mHandoutMaster;
    }

    public OdfDrawLayerSet getLayerSet() {
        return this.mLayerSet;
    }

    public OdfStyleMasterPage getMasterPage(String name) {
        if (this.mMasterPages != null) {
            return this.mMasterPages.get(name);
        }
        return null;
    }

    public Iterator<OdfStyleMasterPage> getMasterPages() {
        if (this.mMasterPages != null) {
            return this.mMasterPages.values().iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfDrawLayerSet) {
            this.mLayerSet = (OdfDrawLayerSet)node;
        } else if (node instanceof OdfStyleHandoutMaster) {
            this.mHandoutMaster = (OdfStyleHandoutMaster)node;
        } else if (node instanceof OdfStyleMasterPage) {
            OdfStyleMasterPage masterPage = (OdfStyleMasterPage)node;
            if (this.mMasterPages == null) {
                this.mMasterPages = new HashMap();
            }
            this.mMasterPages.put(masterPage.getStyleNameAttribute(), masterPage);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfDrawLayerSet) {
            if (this.mLayerSet == (OdfDrawLayerSet)node) {
                this.mLayerSet = null;
            }
        } else if (node instanceof OdfStyleHandoutMaster) {
            if (this.mHandoutMaster == (OdfStyleHandoutMaster)node) {
                this.mHandoutMaster = null;
            }
        } else if (node instanceof OdfStyleMasterPage && this.mMasterPages != null) {
            OdfStyleMasterPage masterPage = (OdfStyleMasterPage)node;
            this.mMasterPages.remove(masterPage.getStyleNameAttribute());
        }
    }
}

