/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceTreeModel;
import bibliothek.extension.gui.dock.preference.model.BubbleThemePreferenceModel;
import bibliothek.extension.gui.dock.preference.model.ButtonContentPreferenceModel;
import bibliothek.extension.gui.dock.preference.model.EclipseThemePreferenceModel;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.preference.CKeyStrokePreferenceModel;
import bibliothek.gui.dock.common.preference.CLayoutPreferenceModel;
import bibliothek.util.Path;
import bibliothek.util.PathCombiner;

public class CPreferenceModel
extends PreferenceTreeModel {
    public CPreferenceModel(CControl control) {
        this(control, PathCombiner.SECOND);
    }

    public CPreferenceModel(CControl control, PathCombiner combiner) {
        super(combiner, control.getController());
        DockController controller = control.intern().getController();
        this.putLinked(new Path("shortcuts"), "preference.shortcuts", (PreferenceModel)new CKeyStrokePreferenceModel(controller.getProperties()));
        this.putLinked(new Path("buttonContent"), "preference.buttonContent", (PreferenceModel)new ButtonContentPreferenceModel(controller));
        this.putLinked(new Path("layout"), "preference.layout", (PreferenceModel)new CLayoutPreferenceModel(control));
        this.putLinked(new Path("layout.BubbleTheme"), "theme.bubble", (PreferenceModel)new BubbleThemePreferenceModel(controller.getProperties()));
        this.putLinked(new Path("layout.EclipseTheme"), "theme.eclipse", (PreferenceModel)new EclipseThemePreferenceModel(controller.getProperties()));
    }

    public CKeyStrokePreferenceModel getKeyStrokePreferences() {
        PreferenceModel model = this.getModel(new Path("shortcuts"));
        if (model instanceof CKeyStrokePreferenceModel) {
            return (CKeyStrokePreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }

    public CLayoutPreferenceModel getLayoutPreferences() {
        PreferenceModel model = this.getModel(new Path("layout"));
        if (model instanceof CLayoutPreferenceModel) {
            return (CLayoutPreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }

    public ButtonContentPreferenceModel getButtonContent() {
        PreferenceModel model = this.getModel(new Path("buttonContent"));
        if (model instanceof ButtonContentPreferenceModel) {
            return (ButtonContentPreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }

    public BubbleThemePreferenceModel getBubbleThemePreferences() {
        PreferenceModel model = this.getModel(new Path("layout.BubbleTheme"));
        if (model instanceof BubbleThemePreferenceModel) {
            return (BubbleThemePreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }

    public EclipseThemePreferenceModel getEclipseThemePreferences() {
        PreferenceModel model = this.getModel(new Path("layout.EclipseTheme"));
        if (model instanceof EclipseThemePreferenceModel) {
            return (EclipseThemePreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }
}

