/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMenuPiece
extends MenuPiece {
    private List<MenuPiece> children = new ArrayList<MenuPiece>();
    private Listener listener = new Listener();

    public void add(MenuPiece piece) {
        this.insert(this.children.size(), piece);
    }

    public void insert(int index, MenuPiece piece) {
        if (piece.getParent() != null) {
            throw new IllegalArgumentException("piece already has a parent");
        }
        piece.setParent(this);
        this.children.add(index, piece);
        piece.addListener(this.listener);
        this.listener.insert(piece, 0, piece.items());
        if (this.isBound()) {
            piece.bind();
        }
    }

    public void remove(MenuPiece piece) {
        if (this.children.contains(piece)) {
            this.listener.remove(piece, 0, piece.getItemCount());
            piece.removeListener(this.listener);
            piece.setParent(null);
            this.children.remove(piece);
            if (this.isBound()) {
                piece.unbind();
            }
        }
    }

    public void remove(int index) {
        MenuPiece piece = this.children.get(index);
        this.listener.remove(piece, 0, piece.getItemCount());
        piece.removeListener(this.listener);
        piece.setParent(null);
        this.children.remove(index);
        if (this.isBound()) {
            piece.unbind();
        }
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public MenuPiece getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public void fill(List<Component> items) {
        for (MenuPiece piece : this.children) {
            piece.fill(items);
        }
    }

    @Override
    public int getItemCount() {
        int count = 0;
        for (MenuPiece piece : this.children) {
            count += piece.getItemCount();
        }
        return count;
    }

    @Override
    public void bind() {
        if (!this.isBound()) {
            super.bind();
            for (MenuPiece child : this.children) {
                child.bind();
            }
        }
    }

    @Override
    public void unbind() {
        if (this.isBound()) {
            super.unbind();
            for (MenuPiece child : this.children) {
                child.unbind();
            }
        }
    }

    private class Listener
    implements MenuPieceListener {
        private Listener() {
        }

        public void insert(MenuPiece child, int index, Component ... component) {
            MenuPiece piece;
            Iterator i$ = NodeMenuPiece.this.children.iterator();
            while (i$.hasNext() && (piece = (MenuPiece)i$.next()) != child) {
                index += piece.getItemCount();
            }
            NodeMenuPiece.this.fireInsert(index, component);
        }

        public void remove(MenuPiece child, int index, int length) {
            MenuPiece piece;
            Iterator i$ = NodeMenuPiece.this.children.iterator();
            while (i$.hasNext() && (piece = (MenuPiece)i$.next()) != child) {
                index += piece.getItemCount();
            }
            NodeMenuPiece.this.fireRemove(index, length);
        }
    }
}

