% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spex-package.r, R/spex.R
\docType{package}
\name{spex}
\alias{spex}
\alias{spex-package}
\alias{spex}
\alias{spex}
\alias{spex.default}
\alias{spex}
\alias{spex.Extent}
\alias{spex}
\alias{spex.sf}
\title{spex}
\usage{
spex(x, ...)

\method{spex}{default}(x, crs, byid = FALSE, .id, ...)

\method{spex}{Extent}(x, crs, ...)

\method{spex}{sf}(x, crs, ...)
}
\arguments{
\item{x}{any object with a \code{\link[raster]{Extent}}}

\item{...}{arguments for methods}

\item{crs}{a projection string}

\item{byid}{return a separate object for every input sub-object (not yet implemented)}

\item{.id}{optional name for output attribute name}
}
\value{
'SpatialPolygonsDataFrame'
}
\description{
spex

Create Spatial Polygons with projection metadata from a 'Spatial Extent'.
}
\details{
Called with no arguments will return the extent of the current 'par("usr")' setting.
This function is to replace a common pattern in the 'sp'-'raster' family which is
\itemize{
\item create an \code{\link[raster]{Extent}}, a bounding box in xmin,xmax,ymin,ymax but without projection metadata
\item coerce the Extent to \code{\link[sp]{SpatialPolygons}}
\item restore the 'CRS', the "coordinate reference system", i.e. projection metadata
\item elevate the object to be a \code{\link[sp]{SpatialPolygonsDataFrame}}.
}

In short, this pattern exists because there is no projection metadata stored
with either sp''s \code{\link[sp]{bbox}} or 'raster''s \code{\link[raster]{Extent}}.
}
\section{Spatial Extent}{

\tabular{ll}{
\code{\link{spex}} \tab function to produce a fully fledged Spatial object extent \cr
}
}

\section{Warning}{
 Please note that an extent converted to polygons consists
of only four unique coordinates, and so this is not necessarily suited for
projection transformations.
}

\examples{
library(raster)
data(lux)
exlux <- spex(lux)

plot(lux)
plot(exlux, add = TRUE)

## put an extent and a CRS together
spex(extent(0, 1, 0, 1), crs = "+proj=laea +ellps=WGS84")
\dontrun{
 ## library(rgdal)
 ## p4 <- "+proj=laea +ellps=WGS84"
 ## plot(spTransform(lux, p4))
 ## warning, this is just 4 coordinates
 ## plot(spTransform(exlux, p4), add = TRUE)
}
}
\seealso{
This pattern is displayed in the example code for \code{\link[raster]{cover}}.
}
