\name{predict.spikeSlabGAM}
\alias{predict.spikeSlabGAM}
\title{Obtain posterior predictive/credible intervals from a spike-and-slab model...}
\usage{\method{predict}{spikeSlabGAM}(object, newdata, type=c("response", "link", "terms"), terms,
    aggregate=mean, quantiles, addIntercept=is.null(terms),
    ...)
}
\description{Obtain posterior predictive/credible intervals from a spike-and-slab model}
\value{If \code{type="terms"}, a list of \code{data.frame}s containing the requested pointwise summary statistics
for the supplied terms (use e.g. \code{\link{Reduce}("+", ...)} to get row-wise sums of the list-entries). Otherwise, a \code{data.frame} containing the requested pointwise summary statistics
of the posterior predictive of the linear predictor (\code{type="link"}) or the conditional expectation of the response (\code{type="response"}) is returned.}
\author{Fabian Scheipl}
\arguments{\item{object}{a \code{spikeSlabGAM} model}
\item{newdata}{an optional \code{data.frame} on which to evaluate predictions. 
Defaults to NULL, in which case the fitted values for the original data are returned}
\item{type}{the type of prediction required. The default is on the scale of response, 
the alternative \code{'link'} is on the scale of the linear predictor. 
Specifying \code{'terms'} returns a list giving the linear predictors of the terms specified in \code{terms}.}
\item{terms}{an optional character vector of term labels or variable names for which to return fits/predictions/credible regions.
If variable names instead of term labels are supplied, the function returns predictions/estimates for 
\emph{all} terms associated with these variables, 
i.e. their main effects (usually both linear and smooth for numeric covariates) and all interaction terms they are involved in.}
\item{aggregate}{(function) the summary statistic of the posterior predictive of the linear predictor. 
Defaults to \code{mean}.}
\item{quantiles}{(numeric) an optional vector of quantiles for borders of credible regions of the returned values. 
Defaults to NULL.}
\item{addIntercept}{include global intercept term in prediction/estimate? Defaults to TRUE if \code{terms=NULL}.}
\item{...}{arguments passed from or to other methods (not used)}
}

