% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{scale_axes}
\alias{scale_axes}
\title{Returns the axis scale and position.}
\usage{
scale_axes(
  x,
  position = c("center", "left", "right", "bottomleft", "topright", "off",
    "pan_zoom() call;", pan_zoom(c(-1L, 0L), c(0.7, 0.7))),
  to = data.frame(x = c(-1L, 1L), y = c(-1L, 1L))
)
}
\arguments{
\item{x}{Numeric table, first 2 columns and scaled and offset relative to
the \code{to} argument.}

\item{position}{Text specifying the position the axes should go to.
Defaults to "center" expects one of: "center", "left", "right",
"bottomleft", "topright", or "off".}

\item{to}{Table to appropriately set the size and position of the axes to.
Based on the min/max of the first 2 columns.}
}
\value{
Scaled and offset \code{x} typically controlling axes placement.
}
\description{
Typically called, by other functions to scale axes.
}
\examples{
rb <- tourr::basis_random(4, 2)

scale_axes(x = rb, position = "bottomleft")
scale_axes(x = rb, position = "right", to = wine[, 2:3])
}
\seealso{
\code{\link{pan_zoom}} for more manual control.
}
