% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_data.r
\docType{data}
\name{wine}
\alias{wine}
\title{The wine dataset from the UCI Machine Learning Repository.}
\format{
Data frame of 178 observations of 13 variables, target
class \code{Type} and 12 numeric variables.
}
\usage{
wine
}
\description{
The wine dataset contains the results of a chemical analysis of wines grown
in a specific area of Italy. Three types of wine are represented in the 178
samples, with the results of 13 chemical analyses recorded for each sample.
The Type variable has been transformed into a categorical variable.
}
\details{
The data contains no missing values and consist of only numeric data, with a
three class target variable (Type) for classification.

Data frame of 178 observations of 13 variables, target
class \code{Type} and 12 numeric variables:
\itemize{
\item Type, The type of wine, the target factor, 1 (59 obs),
2(71 obs), and 3 (48 obs).
\item Alcohol, Alcohol
\item Malic, Malic acid
\item Ash, Ash
\item Alcalinity, Alcalinity of ash
\item Magnesium, Magnesium
\item Phenols, Total phenols
\item Flavanoids, Flavanoids
\item Nonflavanoids, Nonflavanoid phenols
\item Proanthocyanins, Proanthocyanins
\item Color, Color intensity
\item Hue, Hue
\item Dilution, D280/OD315 of diluted wines
\item Proline, Proline
}

Reproducing this dataset:\preformatted{requireNamespace("rattle.data")
wine
}
}
\examples{
str(wine)
\dontrun{
dat <- scale_sd(wine[, 2:14])
clas <- wine$Type
bas <- prcomp(dat)$rotation[, 1:2]
mvar <- which(abs(bas[, 1]) == max(abs(bas[, 1])))

play_manual_tour(basis = bas, data = dat, manip_var = mvar,
                 render_type = render_gganimate, color = clas, shape = clas)
}
}
\keyword{datasets}
