% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{animate_plotly}
\alias{animate_plotly}
\title{Animate a ggtour as and HTML widget via \code{{plotly}}}
\usage{
animate_plotly(ggtour, fps = 8, ...)
}
\arguments{
\item{ggtour}{A grammar of graphics tour with appended protos added.
A return from \verb{ggtour() + proto_*()}.}

\item{fps}{Scalar number of Frames Per Second, the speed the animation should
play at.}

\item{...}{Other arguments passed to
\code{\link[plotly:ggplotly]{plotly::ggplotly}}.}
}
\description{
Animates the static \code{ggtour()} and added \verb{proto_*()} functions as a
\code{{plotly}} animation, an .html widget with slider and hover tooltip showing
the row number.
}
\examples{
library(spinifex)
dat     <- scale_sd(penguins[, 1:4])
clas    <- penguins$species
bas     <- basis_pca(dat)
mv      <- manip_var_of(bas)
mt_path <- manual_tour(bas, manip_var = mv)

ggt <- ggtour(mt_path, dat, angle = .3) +
  proto_origin() +
  proto_basis() +
  proto_point(aes_args = list(color = clas, shape = clas),
              identity_args = list(size = 1.5, alpha = .7))
\dontrun{
animate_plotly(ggt, width = 700, height = 450) ## pixels only, no resolution argument

## Example saving to a .html widget, may require additional setup.
if(F){
  anim <- animate_plotly(ggt, fps = 10,
                         width = 700, height = 450) ## in pixels
  
  htmlwidgets::saveWidget(widget = anim,
                          file = "./figures/my_tour.html",
                          selfcontained = TRUE)}
}
}
\seealso{
Other ggtour animator: 
\code{\link{animate_gganimate}()},
\code{\link{filmstrip}()}
}
\concept{ggtour animator}
