\name{spiral_bars}
\alias{spiral_bars}
\title{
Add bars to a track
}
\description{
Add bars to a track
}
\usage{
spiral_bars(pos, value, baseline = get_track_data("ymin", track_index),
    bar_width = min(diff(pos)), gp = gpar(), track_index = current_track_index())
}
\arguments{

  \item{pos}{X-locations of the center of bars.}
  \item{value}{Height of bars. The value can be a simple numeric vector, or a matrix.}
  \item{baseline}{Baseline of the bars. Note it only works when \code{value} is a simple vector.}
  \item{bar_width}{Width of bars.}
  \item{gp}{Graphical parameters.}
  \item{track_index}{Index of the track. }

}
\value{
No value is returned.
}
\examples{
\donttest{
x = seq(1, 1000, by = 1) - 0.5
y = runif(1000)
spiral_initialize(xlim = c(0, 1000))
spiral_track(height = 0.8)
spiral_bars(x, y)

# a three-column matrix
y = matrix(runif(3*1000), ncol = 3)
y = y/rowSums(y)
spiral_initialize(xlim = c(0, 1000))
spiral_track(height = 0.8)
spiral_bars(x, y, gp = gpar(fill = 2:4, col = NA))
}
}
