# Copyright Barry Rowlingson <b.rowlingson@lancaster.ac.uk> and 
# Peter Diggle (c) 1991-3; http://www.maths.lancs.ac.uk/~rowlings/Splancs/
# R port: copyright 1998-2000 by Roger S. Bivand

mse2d <- function(pts,poly,nsmse,range)
{
#	library.dynam("splancs","twodimmse.o")
	ptsx <- pts[,1]
	ptsy <- pts[,2]
	nptsm <- npts(pts)
	
	a1 <- min(poly[,1],na.rm=TRUE)
	a2 <- max(poly[,1],na.rm=TRUE)
	b1 <- min(poly[,2],na.rm=TRUE)
	b2 <- max(poly[,2],na.rm=TRUE)
	
	hsmse <- range/nsmse
	amse <- rep(0,nsmse)
	t <- rep(0,nsmse)
	
	mselist <- .Fortran("mse2d",
		as.double(ptsx),
		as.double(ptsy),
		as.integer(nptsm),
		as.double(a1),
		as.double(a2),
		as.double(b1),
		as.double(b2),
		as.integer(nsmse),
		as.double(hsmse),
		as.double(amse),
		as.double(t),
		PACKAGE="splancs")
		
	list(mse=mselist[[10]],h=mselist[[11]])
}
