% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.spmod}
\alias{print.spmod}
\alias{print.summary.spmod}
\alias{print.anova.spmod}
\title{Print values}
\usage{
\method{print}{spmod}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{summary.spmod}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{print}{anova.spmod}(
  x,
  digits = max(getOption("digits") - 2L, 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}} or output from
\code{summary(x)} or or \code{anova(x)}.}

\item{digits}{The number of significant digits to use when printing.}

\item{...}{Other arguments passed to or from other methods.}

\item{signif.stars}{Logical. If \code{TRUE}, significance stars are printed for each coefficient}
}
\value{
Printed fitted model objects and summaries with formatting.
}
\description{
Print fitted model objects and summaries.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
print(spmod)
print(summary(spmod))
print(anova(spmod))
}
