% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkt_vis.r
\name{wkt_vis}
\alias{wkt_vis}
\title{Visualize well-known text area's on a map.}
\usage{
wkt_vis(x, zoom = 6, maptype = "terrain", browse = TRUE)
}
\arguments{
\item{x}{Input well-known text area (character)}

\item{zoom}{Zoom level, defaults to 6 (numeric)}

\item{maptype}{Map type, default is terrain (character)}

\item{browse}{Open in browser or not. If not, gives back
path to html file. Default: \code{TRUE} (logical)}
}
\description{
This can be helpful in visualizing the area in which you are searching for
occurrences with the \code{\link[=occ]{occ()}} function.
}
\details{
Uses Mapbox's map layers, openes in your default browser
}
\examples{
\dontrun{
poly <- 'POLYGON((-111.06 38.84, -110.80 39.37, -110.20 39.17, -110.20 38.90,
     -110.63 38.67, -111.06 38.84))'
wkt_vis(poly)

poly2 <- 'POLYGON((-125 38.4,-125 40.9,-121.8 40.9,-121.8 38.4,-125 38.4))'
wkt_vis(poly2)

# Multiple polygons
x <- "POLYGON((-125 38.4, -121.8 38.4, -121.8 40.9, -125 40.9, -125 38.4), 
(-115 22.4, -111.8 22.4, -111.8 30.9, -115 30.9, -115 22.4))"
wkt_vis(x)

# don't open in browser
poly2 <- 'POLYGON((-125 38.4,-125 40.9,-121.8 40.9,-121.8 38.4,-125 38.4))'
wkt_vis(poly2, browse = FALSE)
}
}
\seealso{
Other bbox: \code{\link{bbox2wkt}}
}
\concept{bbox}
