% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/occ2sp.R
\name{occ2sp}
\alias{occ2sp}
\title{Create a spatial points dataframe from a spocc search}
\usage{
occ2sp(x, coord_string = "+proj=longlat +datum=WGS84", just_coords = FALSE)
}
\arguments{
\item{x}{The resuslts of a spocc search called by occ()}

\item{coord_string}{A valid EPGS cooridate string from the sp package, the default is WSGS 84}

\item{just_coords}{Return data frame with specios names and provenance or just a spatial points
object, which is the default.}
}
\description{
Create a spatial points dataframe from a spocc search
}
\details{
This function will return either a spatial points dataframe or spatial points object.
Conversion to spatial points objects allows spocc searches to interact with other spatial
data sources. More coordinate system codes can be found at the EPGS registry:
\url{http://www.epsg-registry.org/}
}
\examples{
\dontrun{
### See points on a map
library("maptools")
library("spocc")
data(wrld_simpl)
plot(wrld_simpl[wrld_simpl$NAME == "United States", ], xlim = c(-70, -60))
out <- occ(query = "Accipiter striatus", from = c("ecoengine", "gbif"), limit = 50)
sp_points <- occ2sp(out, just_coords = TRUE)
points(sp_points, col = 2)
}
}

