% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spork.R
\name{as_spork}
\alias{as_spork}
\title{Coerce to Spork}
\usage{
as_spork(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}
}
\value{
spork
}
\description{
Coerces to class 'spork'. Generic,
with method \code{\link{as_spork.character}}.
A spork is simple text expressing
arbitrarily nested subscripts (\code{x_y_z})
and superscripts (\code{x^y^z}). A dot
(\code{x^y._z}) explicitly terminates
a group. An asterisk (\code{*}) suggests
multiplication; a literal backslash
followed by 'n' suggests a newline
(handling differs for latex vs. plotmath).
Special characters may be escaped with a backslash.
Convert to plotmath with \code{\link{as_plotmath}}
and to latex with \code{\link{as_latex}}.
Both plotmath and latex names of Greek
letters are supported; see \code{\link{as_previews.spork}}
and examples there for disambiguation.
}
\examples{
library(ggplot2)
label <- 'one joule (Omega) ~ 1 kg*m^2./s^2'
label <- as_spork(label)
label <- as_plotmath(label)
label <- as.expression(label)
x <- data.frame(y=1:10, x=1:10)
p <- ggplot(x, aes(x, y))
p$labels$x <- label

print(p)
}
\seealso{
Other spork: \code{\link{[.spork}}, \code{\link{[[.spork}},
  \code{\link{as.list.spork}}, \code{\link{as.png.spork}},
  \code{\link{as_latex.spork}},
  \code{\link{as_plotmath.spork}},
  \code{\link{as_previews.spork}},
  \code{\link{as_spar.spork}},
  \code{\link{as_spork.character}},
  \code{\link{as_spork.factor}},
  \code{\link{as_spork.spork}}, \code{\link{ggplot.spork}}
}
\concept{spork}
\keyword{internal}
