% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geniusR.R
\name{get_discography}
\alias{get_discography}
\title{Retrieve artist discography with song lyrics and audio info}
\usage{
get_discography(artist, authorization = get_spotify_access_token())
}
\arguments{
\item{artist}{The quoted name of the artist. Spelling matters, capitalization does not.}

\item{authorization}{Authorization token for Spotify web API. Defaults to \code{get_spotify_access_token()}}
}
\description{
Retrieve the entire discography of an artist with the lyrics of each song and the associated audio information. Returns the song data as a nested tibble. This way we can easily see each album, artist, and song title before expanding our data.
}
\examples{
\dontrun{
rex_orange <- get_discography("Rex Orange County")
unnest(rex_orange, data)
}
}
