% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users_profile.R
\name{get_user_profile}
\alias{get_user_profile}
\title{Get public profile information about a Spotify user.}
\usage{
get_user_profile(user_id, authorization = get_spotify_access_token())
}
\arguments{
\item{user_id}{Required. The user's \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify user ID}.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{Web API authorization Guide}{https://developer.spotify.com/documentation/general/guides/authorization-guide/} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}
}
\value{
Returns a data frame of results containing user profile information. See \url{https://developer.spotify.com/documentation/web-api/reference/users-profile/get-users-profile/} for more information.
}
\description{
Get public profile information about a Spotify user.
}
