% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_post.R
\name{GetDensityValues}
\alias{GetDensityValues}
\title{Retrieve density values}
\usage{
GetDensityValues(fit)
}
\arguments{
\item{fit}{Object of class \code{damcmc_res} or \code{bdmcmc_res}.}
}
\value{
A list containing the following components:
\item{Marginal}{the value of the Marginal (approximately)}
\item{LogLikelihood}{the value of the LogLikelihood}
\item{CompDensityAtXi}{the value of the component densities across all realizations and for each data point}
\item{DensityAtXi}{the value of the mixture density across all realizations and for each data point}
\item{EntropyMAP}{an approximation of the entropy of the distribution of the component indicators}
\item{Density}{the joint density at each posterior realization, i.e., for each iteration of \code{ps}, \code{mus} and \code{sigmas}.}
}
\description{
This function operates on the point pattern and the realizations of
a DAMCMC or BDMCMC fit (object \code{damcmc_res} or \code{bdmcmc_res})
and returns a plethora of information about the fit. When a \code{bdmcmc_res} is passed,
only the realizations corresponding to the MAP number of components are used for calculations.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#GetDensityValues}
}
\examples{

\dontrun{
# create the true mixture intensity surface
truesurf =normmix(ps=c(.2, .6,.2), mus=list(c(0.3, 0.3), c(0.7, 0.7),
 c(0.5, 0.5)),sigmas=list(.01*diag(2), .01*diag(2), .01*diag(2)),
 lambda=100,win=spatstat::square(1))
plot(truesurf)
# generate the point pattern, truncate=TRUE by default
genPP=rsppmix(truesurf,truncate=FALSE)
fit=est_mix_damcmc(pp = genPP, m = 3)
allvals=GetDensityValues(fit)
MAPest=GetMAPEst(fit,vals=allvals)
plot(MAPest,main="IPPP intensity surface of MAP estimates")}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{normmix}},
\code{\link{est_mix_damcmc}},
\code{\link{est_mix_bdmcmc}},
\code{\link{rsppmix}}
}

