% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_intensity_np.R
\name{est_intensity_np}
\alias{est_intensity_np}
\title{Estimate the intensity surface using a non-parametric method}
\usage{
est_intensity_np(pattern, win, h, L = 10, kernel = c("Epanechnikov"),
  edgecorrect = TRUE, truncate = TRUE)
}
\arguments{
\item{pattern}{A two-dimesional spatial point pattern in
the form of a \code{\link[spatstat]{ppp}} object.}

\item{win}{Object of class \code{\link[spatstat]{owin}}.}

\item{h}{Kernel bandwidth. \code{h} should be a positive number.}

\item{L}{Length of the side of the square grid.}

\item{kernel}{Kernel used to estimate the intensity surface.  Currently, only
supports the Epanechnikov kernel.}

\item{edgecorrect}{Logical flag indicating whether or not
to use edge-correction in the estimating intensity surface. The default is TRUE.}

\item{truncate}{Logical flag indicating whether or not to use
points only within the window. The default is TRUE.}
}
\value{
An object of class \code{\link[spatstat]{im}}.
}
\description{
Using an Epanechnikov kernel we calculate an estimate of
intensity surface while accounting for edge effects.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#est_intensity_np}
}
\examples{
\donttest{
mix1 <- rnormmix(5, sig0 = .01, df = 5, xlim=c(0, 5),ylim=c(0, 5))
intsurf1=to_int_surf(mix1,lambda = 40, win =spatstat::owin( c(0, 5),c(0, 5)))
plot(intsurf1)
pp1 <- rsppmix(intsurf1)
# estimate and plot the estimated intensity surface
surfNP1 <- est_intensity_np(pp1, win=spatstat::owin( c(0, 5),c(0, 5)), h=0.05,
 L=100,truncate = FALSE)
plotmix_3d(surfNP1,title1="Non parametric estimator of the intensity surface")
#truncate components to have all their mass in the window
surfNP2 <- est_intensity_np(pp1, win=spatstat::owin( c(0, 5),c(0, 5)), h=0.5, L=100)
plotmix_3d(surfNP2,title1="(Truncated) Non parametric estimator of the intensity surface")}

}
\seealso{
\code{\link{rnormmix}},
\code{\link{to_int_surf}},
\code{\link{rsppmix}},
\code{\link{plotmix_3d}}
}
\author{
Jiaxun Chen, Sakis Micheas
}
