% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.map.test.R
\name{Q.map.test}
\alias{Q.map.test}
\title{Compute the QE and QI tests of Equivalence and Independence between maps}
\usage{
Q.map.test(formula = formula, data = data, coor = NULL, m = m, r = 1,
type = "combinations", control = list())
}
\arguments{
\item{formula}{a symbolic description of the two factors.}

\item{data}{(optional) a data frame or a sf object containing the variables to testing for.}

\item{coor}{(optional) a 2xN vector with coordinates.}

\item{m}{length of m-surrounding.}

\item{r}{maximum overlapping between any two m-surroundings (default = 1).}

\item{type}{Type of symbols: "permutations" or "combinations". Default "combinations"}

\item{control}{Optional argument. See Control Argument section.}
}
\value{
A list with two objects of the class \code{htest}. The first one
is the QE test of Equivalence between maps and the second one is the QI test
of independence between maps. the elements of each test are: \cr
  \tabular{ll}{
    \code{method} \tab a character string giving description of the method. \cr
    \code{data.name} \tab a character string giving the name(s) of the data. \cr
    \code{statistic} \tab the value of the statistic QE or/and QI. \cr
    \code{alternative} \tab a character string describing the alternative hypothesis. \cr
    \code{p.value} \tab  p-value for QE or QI. \cr
    \code{parameter} \tab free degree of the statistic for QE or QI. \cr
    \code{symb} \tab A matrix with the symbols. \cr
    \code{mh} \tab m-surrounding of th map. \cr
    \code{Tm} \tab number of maps (ONLY 2). \cr
    \code{sample.size} \tab  number of symbolized observations. \cr
    \code{nsk} \tab a matrix Tm x symbols with the frequency of the number of symbols of each map. \cr
    }
}
\description{
This function compute the QE and QI tests for maps comparison based on symbolic entropy.
}
\details{
If \code{data} is not a sf object the \code{coor} argument with the coordinates
of each observation must be included. \cr
}
\section{Control arguments}{

Several parameters to construct the m-surrounding
\describe{
\item{dtmaxabs}{Delete degenerate surrounding based on the absolute distance between observations.}
\item{dtmaxpc}{A value between 0 and 1. Delete degenerate surrounding based on the distance.
Delete m-surrounding when the maximum distance between observation
is upper than k percentage of maximum distance between anywhere observation.}
\item{dtmaxknn}{A integer value 'k'. Delete degenerate surrounding based on the near neighborhood criteria. Delete m-surrounding
is a element of the m-surrounding is not include in the set of k near neighborhood of the first element}
\item{seedinit}{seed to select the initial element to star
the algorithm to compute the m-surroundings.}
}
}

\examples{

# Case 1:
N <- 200
cx <- runif(N)
cy <- runif(N)
x <- cbind(cx,cy)
listw <- spdep::nb2listw(spdep::knn2nb(
           spdep::knearneigh(cbind(cx,cy), k = 4)))
p <- c(1/6, 3/6, 2/6)
rho = 0.5
QY1 <- dgp.spq(p = p, listw = listw, rho = rho)
rho = 0.8
QY2 <- dgp.spq(p = p, listw = listw, rho = rho)
dt = data.frame(QY1,QY2)
m = 3
r = 1
formula <- ~ QY1 + QY2
control <- list(dtmaxknn = 10)
qmap <- Q.map.test(formula = formula, data = dt, coor = x, m = m, r = r,
                   type ="combinations", control = control)
print(qmap)
plot(qmap)
plot(qmap, ci=.6)
plot(qmap[[1]]$mh)
summary(qmap[[1]]$mh)

control <- list(dtmaxknn = 20)
qmap <- Q.map.test(formula = formula, data = dt, coor = x, m = m, r = r,
                   type ="permutations", control = control)
print(qmap)
plot(qmap)
plot(qmap[[1]]$mh)
qmap <- Q.map.test(formula = formula, data = dt, coor = x, m = m, r = r,
                   type ="combinations")
print(qmap)
plot(qmap)
control <- list(dtmaxknn = 10)
qmap <- Q.map.test(formula = formula, data = dt, coor = x, m = m, r = r,
                   type ="combinations", control = control)
print(qmap)
plot(qmap)

# Case 2:
data(provinces_spain)
# sf::sf_use_s2(FALSE)
m = 3
r = 1

provinces_spain$Mal2Fml <- factor(provinces_spain$Mal2Fml > 100)
levels(provinces_spain$Mal2Fml) = c("men","woman")
provinces_spain$Coast <- factor(provinces_spain$Coast)
levels(provinces_spain$Coast) = c("no","yes")
formula <- ~ Coast + Mal2Fml
qmap <- Q.map.test(formula = formula, data = provinces_spain, m = m, r = r,
                   type ="combinations")
print(qmap)
plot(qmap)
plot(qmap[[1]]$mh)

control <- list(dtmaxknn = 6)
qmap <- Q.map.test(formula = formula, data = provinces_spain, m = m, r = r,
                   type ="combinations", control = control)
print(qmap)
plot(qmap[[1]]$mh)
summary(qmap[[1]]$mh)

}
\references{
\itemize{
    \item Ruiz M, López FA and A Páez (2011).
    Comparison of Thematic Maps Using Symbolic Entropy.
      \emph{International Journal of Geographical Information Science}, 26, 413-439.
    \item Ruiz, M., López, FA, and Páez, A. (2010).
    Testing for spatial association of qualitative data using symbolic dynamics.
    \emph{Journal of Geographical Systems}, 12(3), 281-309.0.
  }
}
\seealso{
\code{\link{dgp.spq}}, \code{\link{m.surround}}, \code{\link{Q.test}}
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Antonio Páez \tab \email{paezha@gmail.com} \cr
  Manuel Ruiz \tab \email{manuel.ruiz@upct.es} \cr
  }
}
