% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/expected.num.species.R
\name{expected.num.species}
\alias{expected.num.species}
\title{Expected Number of Species}
\usage{
expected.num.species(m, f, f0.func = Chao1, ...)
}
\arguments{
\item{m}{number of samples.}

\item{f}{a vector of species frequencies where \code{f[i]} is the number of species
represented by only \code{i} samples.}

\item{f0.func}{a function that computes the number of unobserved species (f0).}

\item{...}{other arguments to \code{f0.func}.}
}
\value{
a vector of the estimated number of species (\code{s.ind}) seen in \code{m} samples,
  and the standard deviation (\code{sd.s.ind}).
}
\description{
Calculate the expected number of species for a given sample size.
}
\examples{
data(osa.old.growth)
f <- expand.freqs(osa.old.growth)
expected.num.species(60, f)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Eqns 4, 5, 9, and 10 in Colwell, R.K., A. Chao, N.J. Gotelli, S.-Y. Lin,
  C.X. Mao, R.L. Chazdon, and J.T. Longino. 2012. Models and estimators linking
  individual-based and sample-based rarefaction, extrapolation and comparison of assemblages.
  Journal of Plant Ecology 5(1):3-21.
}

