% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attrisk.var.R
\name{attrisk.var}
\alias{attrisk.var}
\title{Compute the Variance Estimate for Attributable Risk}
\usage{
attrisk.var(response, stressor, response.levels, stressor.levels, wgt, x,
  y, stratum.ind, stratum.level, cluster.ind, cluster, wgt1, x1, y1,
  pcfactor.ind, pcfsize, N.cluster, stage1size, support, vartype, warn.ind,
  warn.df, warn.vec)
}
\arguments{
\item{response}{Vector of the categorical response variable.}

\item{stressor}{Vector of the categorical stressor variable.}

\item{response.levels}{Vector of category values (levels) for the
categorical response variable.  If response.levels equals NULL, then values
"Poor" and "Good" are used for the first level and second level of the
response variable, respectively.  The default is NULL.}

\item{stressor.levels}{Vector of category values (levels) for the
categorical stressor variable.  If stressor.levels equals NULL, then values
"Poor" and "Good" are used for the first level and second level of the
stressor variable, respectively.  The default is NULL.}

\item{wgt}{Vector of the final adjusted weight (inverse of the sample
inclusion probability) for each site, which is either the weight for a
single-stage sample or the stage two weight for a two-stage sample.}

\item{x}{Vector of x-coordinate for location for each site, which is either
the x- coordinate for a single-stage sample or the stage two x-coordinate
for a two-stage sample.}

\item{y}{Vector of y-coordinate for location for each site, which is either
the y- coordinate for a single-stage sample or the stage two y-coordinate
for a two-stage sample.}

\item{stratum.ind}{Logical value that indicates whether the sample is
stratified, where TRUE = a stratified sample and FALSE = not a stratified
sample.}

\item{stratum.level}{Vector of the stratum levels for the sites.}

\item{cluster.ind}{Logical value that indicates whether the sample is a
two- stage sample, where TRUE = a two-stage sample and FALSE = not a
two-stage sample.}

\item{cluster}{Vector of the stage one sampling unit (primary sampling unit
or cluster) code for each site.}

\item{wgt1}{Vector of the final adjusted stage one weight for each site.}

\item{x1}{Vector of the stage one x-coordinate for location for each site.}

\item{y1}{Vector of the stage one y-coordinate for location for each site.}

\item{pcfactor.ind}{Logical value that indicates whether the population
correction factor is used during variance estimation, where TRUE = use the
population correction factor and FALSE = do not use the factor.  To employ
the correction factor for a single-stage sample, values must be supplied
for arguments pcfsize and support.  To employ the correction factor for a
two-stage sample, values must be supplied for arguments N.cluster,
stage1size, and support.}

\item{pcfsize}{Size of the resource, which is required for calculation of
finite and continuous population correction factors for a single-stage
sample. For a stratified sample this argument must be a vector containing a
value for each stratum and must have the names attribute set to identify
the stratum codes.}

\item{N.cluster}{The number of stage one sampling units in the resource,
which is required for calculation of finite and continuous population
correction factors for a two-stage sample.  For a stratified sample this
variable must be a vector containing a value for each stratum and must have
the names attribute set to identify the stratum codes.}

\item{stage1size}{Size of the stage one sampling units of a two-stage
sample, which is required for calculation of finite and continuous
population correction factors for a two-stage sample and must have the
names attribute set to identify the stage one sampling unit codes.  For a
stratified sample, the names attribute must be set to identify both stratum
codes and stage one sampling unit codes using a convention where the two
codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1".}

\item{support}{Vector of the support value for each site - the value one
(1) for a site from a finite resource or the measure of the sampling unit
associated with a site from a continuous resource, which is required for
calculation of finite and continuous population correction factors.}

\item{vartype}{The choice of variance estimator, where "Local" = local mean
estimator and "SRS" = SRS estimator.}

\item{warn.ind}{Logical value that indicates whether warning messages were
generated, where TRUE = warning messages were generated and FALSE = warning
messages were not generated.}

\item{warn.df}{A data frame for storing warning messages.}

\item{warn.vec}{Vector that contains names of the population type, the
subpopulation, and an indicator.}
}
\value{
An object in list format composed of a vector named varest, which
  contains the variance-covariance estimate, a logical variable named
  warn,ind, which is the indicator for warning messges, and a data frame
  named warn.df, which contains warning messages.
}
\description{
This function calculates the variance-covariance estimate for the cell totals
used to calculate the attributable risk estimate.  Either the simple random
sampling (SRS) variance estimator or the local mean variance estimator is
calculated, which is subject to user control.  The SRS variance estimator
uses the independent random sample approximation to calculate joint inclusion
probabilities.  The function can  accomodate single-stage and two-stage
samples.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{\link{localmean.cov}}}{calculate the variance/covariance
      matrix using the local mean estimator}
    \item{\code{\link{localmean.weight}}}{calculate the weighting matrix for 
       the local mean variance estimator}
  }
}

\seealso{
\code{\link{attrisk.est}} for estimating single relative risk and 
  \code{\link{attrisk.analysis}} for estimating relative risk for multiple
    variables or subpopulations.
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
