% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjwgt.R
\name{adjwgt}
\alias{adjwgt}
\title{Adjust Survey Design Weights by Categories}
\usage{
adjwgt(sites, wgt, wtcat, framesize)
}
\arguments{
\item{sites}{Vector of the logical value for each site, where TRUE = include
the site and FALSE = do not include the site.}

\item{wgt}{Vector of the initial weight (inverse of the sample inclusion
probability) for each site.}

\item{wtcat}{Vector of the weight adjustment category name for each site.}

\item{framesize}{Vector of the known size of the frame for each category
name in wtcat, which must have the names attribute set to match the
category names used in wtcat.}
}
\value{
Vector of adjusted weights, where the adjusted weight is set to zero
  for sites that have the logical value in the sites argument set to FALSE.
}
\description{
Purpose of this function is to adjust initial survey design weights when
  implementation results in use of oversample sites or when it is desired to
  have final weights sum to known frame size.  Adjusted weights are equal to
  initial weight * framesize/sum(initial weights).  The adjustment is done
  separately for each category specified in wtcat.
}
\examples{
sites <- as.logical(rep(rep(c("TRUE","FALSE"), c(9,1)), 5))
wgt <- runif(50, 10, 100)
wtcat <- rep(c("A","B"), c(30, 20))
framesize <- c(15, 10)
names(framesize) <- c("A","B")
adjwgt(sites, wgt, wtcat, framesize)

}
\author{
Tony Olsen \email{olsen.tony@epa.gov}
}
\keyword{misc}
\keyword{survey}
