% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.slmfit.R
\name{predict.slmfit}
\alias{predict.slmfit}
\title{Perform Finite Population Block Kriging}
\usage{
\method{predict}{slmfit}(object, wtscol = NULL, conf_level = 0.9, ...)
}
\arguments{
\item{object}{is an object generated from \code{\link{slmfit}()}}

\item{wtscol}{is the name of the column that contains the weights
for prediction. The default setting predicts the population total}

\item{conf_level}{is the confidence level for a prediction
interval, 0.90 by default}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with \itemize{
  \item the estimated population total
  \item the estimated prediction variance
  \item a data frame containing \enumerate{
       \item x-coordinates
       \item y-coordinates
       \item density predictions
       \item count predictions
       \item site-by-site density prediction variances
       \item site-by-site count prediction variances
       \item indicator variable for whether or not the each site was sampled
       \item estimated mean for each site
       \item area of each site
       }
   \item vector with estimated covariance parameters
   \item the formula used to fit the model in \code{slmfit()}
   \item the confidence level
   \item the confidence interval bounds
}
}
\description{
Uses an object of class \code{slmfit} from the \code{\link{slmfit}()}
 function to predict the response on the unsampled sites.
The column of the data set that has the response should have numeric values for the observed response
on the sampled sites and `NA` for any site that was not sampled.
Note that there is no \code{newdata} argument to
\code{predict.slmfit()}: any point in space for which a prediction
is needed should be included in the original data set in \code{\link{slmfit}()}
with the response variable as \code{NA}.
}
\examples{
data(exampledataset) ## load a toy data set
slmobj <- slmfit(formula = counts ~ pred1 + pred2, data = exampledataset,
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
predict(slmobj)
}
