% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.stratafit.R
\name{predict.stratafit}
\alias{predict.stratafit}
\title{Perform Finite Population Block Kriging}
\usage{
\method{predict}{stratafit}(object, wtscol = NULL, conf_level = 0.9, ...)
}
\arguments{
\item{object}{is an object generated from \code{\link{stratafit}()}}

\item{wtscol}{is the name of the column that contains the weights for prediction. The default setting predicts the population total}

\item{conf_level, }{by default, 0.90, this is the desired
confidence level for a prediction interval}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with \itemize{
  \item the estimated population total
  \item the estimated prediction variance
  \item a data frame containing \enumerate{
       \item x-coordinates
       \item y-coordinates
       \item density predictions
       \item count predictions
       \item site-by-site density prediction variances
       \item site-by-site count prediction variances
       \item indicator variable for whether or not the each site was sampled
       \item estimated mean for each site
       \item area of each site
       }
   \item vector with estimated covariance parameters
   \item the formula used to fit the model in \code{slmfit()}
}
}
\description{
Uses an object of class \code{stratafit} from the \code{\link{stratafit}()}
 function to predict the response on the unsampled sites for separate strata.
The column of the data set that has the response should have numeric values for the observed response
on the sampled sites and `NA` for any site that was not sampled.
Note that there is no \code{newdata} argument to
\code{predict.stratafit()}: any point in space for which a prediction
is needed should be included in the original data set in \code{\link{stratafit}()}
with the response variable as \code{NA}.
}
\examples{
data(exampledataset) ## load a toy data set
exampledataset$strata <- c(rep("A", 19), rep("B", 21))
strataobj <- stratafit(formula = counts ~ pred1 + pred2,
 data = exampledataset, stratacol = "strata",
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
predict(strataobj)
}
