% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.slmfit.R
\name{print.summary.slmfit}
\alias{print.summary.slmfit}
\title{Prints the summary of a fitted spatial linear model.}
\usage{
\method{print}{summary.slmfit}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{is an summary object generated from \code{\link{summary.slmfit}()}}

\item{digits}{is the number of digits to be displayed in the
model output}

\item{signif.stars}{is an option to show which predictors
are significant.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with \itemize{
  \item model formula
  \item summary statistics for the residuals.
  \item a table of fixed effects estimates and associated standard errors.
  \item estimated spatial covariance parameter estimates.
  \item generalized r-squared value.
}
}
\description{
This function uses the object that is output from \code{\link{summary.slmfit}()}.
}
\examples{
data(exampledataset) ## load a toy data set
slmobj <- slmfit(formula = counts ~ pred1 + pred2, data = exampledataset,
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
print(summary(slmobj))
}
