% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case-write.R
\name{case_tv}
\alias{case_tv}
\title{Write time varying casefiles to the disk}
\usage{
case_tv(species, parameter, perc_change, outfile, dir_out = "cases",
  dir_models = system.file("models", package = "ss3models"), nyears = 100,
  verbose = FALSE)
}
\arguments{
\item{species}{A vector of species, for which a unique case file will be
generated.}

\item{parameter}{A character value specifying the parameter to add deviates
to. The argument must match the parameter name exactly.}

\item{perc_change}{A vector of percents, which will be used to add deviates
to the parameter specified in \code{parameter}. A percentage must be supplied
for every year in the model.}

\item{outfile}{A character value specifying the case letter and number used
to save the file.}

\item{dir_out}{A character value specifying the directory to save the
\code{outfile} to.}

\item{dir_models}{The path where the models are stored, such that
\code{file.path(dir_models, species, "om", "ss3.ctl")} leads to valid
\code{ss3.ctl} operating model files.}

\item{nyears}{The length time-series included in the model. The length of
\code{perc_change} must equal \code{nyears}.}

\item{verbose}{Useful for debugging to print output to screen. Default is
\code{FALSE}.}
}
\description{
Use \R code to write arguments to the disk, which
will later be used in a \pkg{ss3sim} simulation.
}
\examples{
temp_path <- file.path(tempdir(), "cod")
dir.create(temp_path, showWarnings = FALSE)

d <- system.file("extdata", package = "ss3sim")

om <- file.path(d, "models", "cod-om")
ig <- file.copy(om, temp_path, recursive = TRUE)
ig <- file.rename(file.path(temp_path, "cod-om"), file.path(temp_path, "om"))
verify_input(file.path(temp_path, "om"), type = "om")
ig <- file.rename(file.path(temp_path, "om", "om.ctl"),
  file.path(temp_path, "om", "ss3.ctl"))
case_tv(species = "cod", parameter = "NatM_p_1_Fem_GP_1",
perc_change = rep(0.5, 100), outfile = "G1",
dir_out = temp_path, dir_models = gsub("/cod", "", temp_path),
nyears = 100, verbose = TRUE)
unlink(temp_path, recursive = TRUE)
}
\author{
Peter Kuriyama
}

