% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_tail_compression.R
\name{change_tail_compression}
\alias{change_tail_compression}
\title{Replace tail compression value for length composition data.}
\usage{
change_tail_compression(tail_compression, dat_list, dat_file_out,
  write_file = TRUE)
}
\arguments{
\item{tail_compression}{*The new tail_compression value to be used. Must be a
numeric value, as a proportion. For example 0.1 means 10 percent. See the
SS3 manual for further information. A NULL value indicates no action, a
negative value indicates to SS3 to ignore it (not use that feature).}

\item{dat_list}{An SS data list object as read in from
\code{\link[r4ss]{SS_readdat}} in the \pkg{r4ss} package. Make sure
you select option \code{section=2}.}

\item{dat_file_out}{A string providing the path to the output SS3 \code{.dat} file.}

\item{write_file}{A logical value indicating if the altered file should be
written to the disk. The default value is \code{TRUE}.}
}
\value{
A modified SS3 \code{.dat} file, and that file returned invisibly
  (for testing) as a vector of character lines.
}
\description{
This function replaces the tail compression value for length composition data
in a \code{.dat} file that was read in using \code{\link[r4ss]{SS_readdat}}
with those specified in
\code{tail_compression}. It then writes a new file with name \code{dat_file_out}
into the working directory. If used with \code{\link{run_ss3sim}} the case
file should be named \code{tail_compression}. A suggested case letter is
\code{T}.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}
\author{
Cole Monnahan
}

