% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_f.r
\name{change_f}
\alias{change_f}
\title{Alter the fishing mortality (\emph{F}) values in an SS3 \code{.par} file.}
\usage{
change_f(years, years_alter, fvals, par_file_in = "ss3.par",
  par_file_out = "ss3.par")
}
\arguments{
\item{years}{*Vector of years for which \emph{F} values are specified,
if there is more than one fleet or season the catches must be ordered by
season:year:fishey (e.g., season1year1fishery1, season2year1fishery1,
season1year2fishery1). The actual vector does not have to correspond to
true years but must be the correct length (e.g., instead of
\code{2000:2004} you can use \code{1:5}). Use this argument to create
an index to old values. \code{years_alter} will use values in this vector.
For example, with two seasons and one fishery that operates for 4 years
you could use the following: \code{1:8}.}

\item{years_alter}{*Vector of years for the which \emph{F} values will be altered.
If there is more than one fishery or season, use the mapping system
created in \code{years} because actual year values cannot be recycled.
For example, to change the second season of the second year in the
example above, use: \code{4}.}

\item{fvals}{*Vector of \emph{F} values to be entered into \code{ss3.par} file,
where \code{length(fvals) == length(years_alter)} must be true.}

\item{par_file_in}{A string providing the path to the input SS3 \code{.par} file.}

\item{par_file_out}{A string providing the path to the output SS3 \code{.par} file.}
}
\value{
A modified SS3 \code{.par} file.
}
\description{
Takes an SS3 \code{.par} file and changes the \emph{F} values for specified years.
If used with \code{\link{run_ss3sim}} the case file should be named
\code{F}. A suggested (default) case letter is \code{F}.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\examples{
# Create a temporary folder for the output:
temp_path <- file.path(tempdir(), "ss3sim-f-example")
dir.create(temp_path, showWarnings = FALSE)

# Find the example .par file in the package data:
d <- system.file("extdata", package = "ss3sim")
par_file <- paste0(d, "/change_f/ss3.par")

change_f(years = 1:49, years_alter = 2, fvals = 9999, par_file_in =
par_file, par_file_out = paste0(temp_path, "/test.par"))
}
\seealso{
Other change functions: \code{\link{change_data}},
  \code{\link{change_em_binning}}, \code{\link{change_e}},
  \code{\link{change_maturity}},
  \code{\link{change_retro}}, \code{\link{change_tv}}
}
\author{
Curry James Cunningham
}
