% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locOuts_methods.R
\name{summary.locOuts}
\alias{summary.locOuts}
\title{Summary of Local Outlier Detection}
\usage{
\method{summary}{locOuts}(object, ...)
}
\arguments{
\item{object}{a locOuts object.}

\item{...}{further parameters passed on.}
}
\value{
Prints a summary of the \code{locOuts} object.
}
\description{
Prints a summary of the locOuts object obtained by the function \code{\link[ssMRCD]{local_outliers_ssMRCD}}.
}
\examples{
# set seed
set.seed(1)

# make locOuts object
data = matrix(rnorm(2000), ncol = 4)
coords = matrix(rnorm(1000), ncol = 2)
groups = sample(1:10, 500, replace = TRUE)
lambda = 0.3

# local outlier detection
outs = local_outliers_ssMRCD(data = data,
                             coords = coords,
                             groups = groups,
                             lambda = lambda,
                             k = 10)

# summary method
summary(outs)
}
\seealso{
\code{\link[ssMRCD]{plot.locOuts}}
}
