% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_name_plots.R
\name{name_plot_uncensored}
\alias{name_plot_uncensored}
\title{Graphical representation of named toxicity uncensored data}
\usage{
name_plot_uncensored(fits, unit, logscale, data, horizontals = TRUE)
}
\arguments{
\item{fits}{A list of fits of class \code{fitdist} or \code{fitdistcens}
computed from the same toxicity data.}

\item{unit}{A character vector, the unit of the toxicity data}

\item{logscale}{if \code{TRUE}, uses a logarithmic scale for the \eqn{x}-axis}

\item{data}{A data.frame with column \code{conc} if uncensored data, with
\code{left} and \code{right} if censored data. In any case, must contain a
column \code{name}.}

\item{horizontals}{If \code{TRUE}, draws horizontal lines for the step empirical 
  cumulative distribution function (ecdf). See also \code{\link{plot.stepfun}}.}
}
\value{
A ggplot object.
}
\description{
Create an empirical cumulative distribution function ggplot with a name (i.e.
species names) associated to each observation.
}
