% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto.R
\name{pareto}
\alias{pareto}
\alias{dpareto}
\alias{qpareto}
\alias{ppareto}
\alias{rpareto}
\alias{spareto}
\title{Pareto Distribution}
\usage{
dpareto(x, scale = 1, shape = 1, log = FALSE)

qpareto(p, scale = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

ppareto(q, scale = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

rpareto(n, scale = 1, shape = 1)

spareto(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{scale}{scale parameter.}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Probability density, cumulative distribution,
inverse cumulative distribution, random sample and starting values functions.
}
\details{
The pareto distribution has been deprecated as it is not suitable for SSD data.
The functions are wrappers on the equivalent VGAM functions.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dpareto(x), type = "l")
}
\seealso{
\code{\link[VGAM:ParetoUC]{VGAM::dpareto()}}
}
