% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_discretization_method.R
\name{as_discretization_method}
\alias{as_discretization_method}
\alias{as_discretization_method,character,ANY-method}
\alias{as_discretization_method,missing,function-method}
\title{Cast into a \code{discretization_method} object}
\usage{
as_discretization_method(name, method)

\S4method{as_discretization_method}{character,ANY}(name)

\S4method{as_discretization_method}{missing,`function`}(method)
}
\arguments{
\item{name}{\strong{[character]} The name of the method.}

\item{method}{\strong{[character]} If custom method, the function to use. See
\code{\link{spm_discretize}} for more details.}
}
\value{
An objectof class \code{\link[=discretization_method-class]{discretization_method}}.
}
\description{
Cast a character value into \code{\link[=discretization_method-class]{discretization_method}}
object, using the list of possible methods in \code{\link{spm_methods}}.
}
\examples{
as_discretization_method("tesselate_voronoi")

}
\seealso{
\link{spm_methods}.
}
