% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STVARconstruction.R
\name{swap_B_signs}
\alias{swap_B_signs}
\title{Swap all signs in pointed columns of the impact matrix of a structural STVAR model
  that is identified by heteroskedasticity or non-Gaussianity}
\usage{
swap_B_signs(stvar, which_to_swap, calc_std_errors = FALSE)
}
\arguments{
\item{stvar}{a class 'stvar' object defining a structural STVAR model that is identified by heteroskedasticity
or non-Gaussianity, typically created with \code{fitSSTVAR}.}

\item{which_to_swap}{a numeric vector of length at most \eqn{d} and elemnts in \eqn{1,..,d}
specifying the columns of the impact matrix whose sign should be swapped.}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\value{
Returns an S3 object of class \code{'stvar'} defining a smooth transition VAR model. The returned list
 contains the following components (some of which may be \code{NULL} depending on the use case):
   \item{data}{The input time series data.}
   \item{model}{A list describing the model structure.}
   \item{params}{The parameters of the model.}
   \item{std_errors}{Approximate standard errors of the parameters, if calculated.}
   \item{transition_weights}{The transition weights of the model.}
   \item{regime_cmeans}{Conditional means of the regimes, if data is provided.}
   \item{total_cmeans}{Total conditional means of the model, if data is provided.}
   \item{total_ccovs}{Total conditional covariances of the model, if data is provided.}
   \item{uncond_moments}{A list of unconditional moments including regime autocovariances, variances, and means.}
   \item{residuals_raw}{Raw residuals, if data is provided.}
   \item{residuals_std}{Standardized residuals, if data is provided.}
   \item{structural_shocks}{Recovered structural shocks, if applicable.}
   \item{loglik}{Log-likelihood of the model, if data is provided.}
   \item{IC}{The values of the information criteria (AIC, HQIC, BIC) for the model, if data is provided.}
   \item{all_estimates}{The parameter estimates from all estimation rounds, if applicable.}
   \item{all_logliks}{The log-likelihood of the estimates from all estimation rounds, if applicable.}
   \item{which_converged}{Indicators of which estimation rounds converged, if applicable.}
   \item{which_round}{Indicators of which round of optimization each estimate belongs to, if applicable.}
   \item{seeds}{The seeds used in the estimation in \code{fitSTVAR}, if applicable.}
   \item{LS_estimates}{The least squares estimates of the parameters in the form
     \eqn{(\phi_{1},...,\phi_{M},\varphi_1,...,\varphi_M,\alpha} (intercepts replaced by unconditional means
     if mean parametrization is used), if applicable.}
}
\description{
\code{swap_B_signs} swaps all signs in pointed columns of the impact matrix of
  a structural STVAR model that is identified by heteroskedasticity or non-Gaussianity. For ind skewed t
  models, also the signs of the skewness parameters are swapped accordingly.
}
\details{
All signs in any column of the impact matrix can be swapped without changing the implied reduced form model,
  but for ind skewed t models, also the signs of the corresponding skewness parameter values need to be swapped.
  For model identified by non-Gaussianity, the signs of the columns of the impact matrices of all the regimes are
  swapped accordingly. Note that the sign constraints imposed on the impact matrix via \code{B_constraints} are also
  swapped in the corresponding columns accordingly.

  Also the order of the columns of the impact matrix can be changed (without changing the implied reduced
  form model) as long as the ordering of other related parameters is also changed accordingly. This can be
  done with the function \code{reorder_B_columns}.
}
\examples{
# Create a structural two-variate Student's t STVAR p=2, M=2, model with logistic transition
# weights and the first lag of the second variable as the switching variable, and shocks
# identified by heteroskedasticity:
theta_222logt <- c(0.356914, 0.107436, 0.356386, 0.086330, 0.139960, 0.035172, -0.164575,
  0.386816, 0.451675, 0.013086, 0.227882, 0.336084, 0.239257, 0.024173, -0.021209, 0.707502,
  0.063322, 0.027287, 0.009182, 0.197066, -0.03, 0.24, -0.76, -0.02, 3.36, 0.86, 0.1, 0.2, 7)
mod222logt <- STVAR(p=2, M=2, d=2, params=theta_222logt, weight_function="logistic",
  weightfun_pars=c(2, 1), cond_dist="Student", identification="heteroskedasticity")

# Print the parameter values, W and lambdas are printed in the bottom:
mod222logt

# Swap the signs of the first column of W (or equally the impact matrix):
mod222logt2 <- swap_B_signs(mod222logt, which_to_swap=1)
mod222logt2 # The signs of the first column of the impact matrix are swapped

# Swap the signs of the second column of the impact matrix:
mod222logt3 <- swap_B_signs(mod222logt, which_to_swap=2)
mod222logt3 # The signs of the second column of the impact matrix are swapped

# Swap the signs of both columns of the impact matrix:
mod222logt4 <- swap_B_signs(mod222logt, which_to_swap=1:2)
mod222logt4 # The signs of both columns of the impact matrix are swapped
}
\references{
\itemize{
   \item Lütkepohl H., Netšunajev A. 2018. Structural vector autoregressions with smooth transition in variances.
     \emph{Journal of Economic Dynamics & Control}, \strong{84}, 43-57.
 }
}
\seealso{
\code{\link{GIRF}}, \code{\link{fitSSTVAR}}, \code{\link{reorder_B_columns}}
}
