% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIRFandGFEVD.R
\name{GIRF_int}
\alias{GIRF_int}
\title{INTERNAL Estimate generalized impulse response function for structural STVAR models.}
\usage{
GIRF_int(
  stvar,
  which_shocks,
  shock_size = 1,
  N = 30,
  R1 = 250,
  R2 = 250,
  init_regime = 1,
  init_values = NULL,
  which_cumulative = numeric(0),
  scale = NULL,
  scale_type = c("instant", "peak"),
  scale_horizon = N,
  ci = c(0.95, 0.8),
  use_data_shocks = FALSE,
  data_girf_pars = c(0, 0.75, 0, 0, 1.5),
  ncores = 2,
  burn_in = 1000,
  exo_weights = NULL,
  seeds = NULL,
  use_parallel = TRUE,
  cfact_pars = NULL
)
}
\arguments{
\item{stvar}{an object of class \code{'stvar'}, created by, e.g., \code{fitSTVAR} or \code{fitSSTVAR}.}

\item{which_shocks}{a numeric vector of length at most \eqn{d}
(\code{=ncol(data)}) and elements in \eqn{1,...,d} specifying the
structural shocks for which the GIRF should be estimated.}

\item{shock_size}{a non-zero scalar value specifying the common size for all scalar
components of the structural shock. Note that the conditional covariance
matrix of the structural shock is normalized to an identity matrix and that the
(generalized) impulse responses may not be symmetric with respect to the sign
and size of the shock.}

\item{N}{a positive integer specifying the horizon how far ahead should the
generalized impulse responses be calculated.}

\item{R1}{the number of repetitions used to estimate GIRF for each initial
value.}

\item{R2}{the number of initial values to use, i.e., to draw from \code{init_regime}
 if \code{init_values} are not specified. The confidence bounds
 will be sample quantiles of the GIRFs based on different initial values.
 Ignored if the argument \code{init_value} is specified.
@param init_regime an integer in \eqn{1,...,M} specifying the regime from which
 the initial values should be generated from (see \code{?simulate.stvar}). If
 \code{use_data_shocks=TRUE} this is argument not used and \code{data_girf_pars}
 should be specified instead.}

\item{init_regime}{an integer in \eqn{1,...,M} specifying the regime from which
the initial values should be generated from (using a simulation procedure with a burn-in period).
For models with Gaussian conditional distribution, it is also possible to generate the starting
values from the stationary distribution of a regime. See the details section.}

\item{init_values}{a size \code{[p, d, R2]} array specifying the initial values in each slice
for each Monte Carlo repetition, where d is the number of time series in the system and \code{R2}
is an argument of this function. In each slice, the \strong{last} row will be used as initial values
for the first lag, the second last row for second lag etc. If not specified, initial values will be
drawn from the regime specified in \code{init_regimes}.}

\item{which_cumulative}{a numeric vector with values in \eqn{1,...,d}
(\code{d=ncol(data)}) specifying which the variables for which the impulse
responses should be cumulative. Default is none.}

\item{scale}{should the GIRFs to some of the shocks be scaled so that they
correspond to a specific magnitude of instantaneous or peak response
of some specific variable (see the argument \code{scale_type})?
Provide a length three vector where the shock of interest
is given in the first element (an integer in \eqn{1,...,d}), the variable of
interest is given in the second element (an integer in \eqn{1,...,d}), and
the magnitude of its instantaneous or peak response in the third element
(a non-zero real number). If the GIRFs of multiple shocks should be scaled, provide
a matrix which has one column for each of the shocks with the columns being
the length three vectors described above.}

\item{scale_type}{If argument \code{scale} is specified, should the GIRFs be
scaled to match an instantaneous response (\code{"instant"}) or peak response
(\code{"peak"}). If \code{"peak"}, the scale is based on the largest magnitude
of peak response in absolute value. Ignored if \code{scale} is not specified.}

\item{scale_horizon}{If \code{scale_type == "peak"} what the maximum horizon up
to which peak response is expected? Scaling won't based on values after this.}

\item{ci}{a numeric vector with elements in \eqn{(0, 1)} specifying the
confidence levels of the "confidence intervals" that \strong{do not} quantify uncertainty about the true parameter value
but only uncertainty about the initial value (and possibly sign and size of the shock) within the given regime.}

\item{use_data_shocks}{set \code{TRUE} for a special feature in which for every possible length \eqn{p} history in the data,
or a subset of them if so specified in the argument \code{data_girf_pars}, the GIRF is estimated for a shock that has the
sign and size of the corresponding structural shock recovered from the data. If used, the argument \code{which_shocks}
must specify only one shock. See the details section.}

\item{data_girf_pars}{a length five numeric vector with the following elements determining settings for \code{use_data_shocks=TRUE}
(concerns the single shock specified in the argument \code{which_shocks}):
\enumerate{
  \item An integer between \code{0} and \code{M} determining the (dominant) regime for which the GIRF should be calculated (\code{0}
    for all regimes).
  \item A number between \code{0.5} and \code{1} determining how large transition weight a regime should have to be considered dominant
    in a given time period (i.e., determining which histories are used to calculate the GIRF if the first element is not \code{0}).
  \item Either \code{0}, \code{-1}, or \code{1}, determining whether the GIRF should be calculated using shocks of all signs,
    only negative shocks, or only positive shocks, respectively.
  \item Either, \code{0}, \code{1}, or \code{2}, determining whether the GIRF should be calculated using shocks of all sizes,
    only small shocks, or only large shocks, respectively.
  \item A strictly positive real number determining what size shocks are considered large and what size small "in the scale of standard
    deviations" (for example, if set to \code{2}, shocks larger than that are considered large and shocks smaller than that are considered
    small; note that the standard deviations of the shocks are normalized to unity).
}}

\item{ncores}{the number CPU cores to be used in parallel computing. Only
single core computing is supported if an initial value is specified (and
the GIRF won't thus be estimated multiple times).}

\item{burn_in}{Burn-in period for simulating initial values from a regime.}

\item{exo_weights}{if \code{weight_function="exogenous"}, provide a size
\eqn{(N+1 \times M)} matrix of exogenous transition weights for the regimes: \code{[h, m]}
for the (after-the-impact) period \eqn{h-1} and regime \eqn{m} weight (\code{[1, m]}
is for the impact period). Ignored if \code{weight_function != "exogenous"}.}

\item{seeds}{A numeric vector initializing the seeds for the random number generator
for estimation of each GIRF. Should have the length of at least (extra seeds are removed
from the end of the vector)...
 \describe{
   \item{If initial values are drawn using \code{init_regime}:}{\code{R2}}
   \item{If initial values are specified in \code{init_values}:}{\code{dim(init_values)[3]}}
   \item{If \code{use_data_shocks=TRUE}:}{1 (the vector of seeds are generated according on the number of histories
     in the data that satisfy the conditions given in the argument \code{data_girf_pars}).}
 }
 Set \code{NULL} for not initializing the seed.}

\item{use_parallel}{employ parallel computing? If \code{FALSE}, does not print
anything.}

\item{cfact_pars}{a list parameters used for calculating counterfactual GIRFs (set to \code{NULL} for regular GIRFs).
Contains the elements:
\describe{
  \item{\code{cfact_metatype}}{should be always \code{"counterfactual_girf"}.}
  \item{\code{cfact_type}}{a character string indicating the type of counterfactual to be computed: should the path of the policy
   variable be fixed to some hypothetical path (\code{cfact_type="fixed_path"}) in given impulse response horizons or should the responses
   of the policy variable to lagged and contemporaneous movements of some given variable be muted (\code{cfact_type="muted_response"})?
   See details for more information.}
  \item{\code{policy_var}}{a positive integer between \eqn{1} and \eqn{d} indicating the index of the policy variable considered in the
   counterfactual scenario. Note that \code{policy_var} is assumed to satisfy \code{!(policy_var \%in\% which_shocks)}.}
  \item{\code{mute_var}}{a positive integer between \eqn{1} and \eqn{d} indicating the index of the variable to whose movements the policy variable
   specified in the argument \code{policy_var} should not react to in the counterfactual scenario. This indicates also the index of the shock
   to which the policy variable should not react to. It is assumed that \code{mute_var != policy_var}. This argument is only used when
   \code{cfact_type="muted_response"}.}
  \item{\code{cfact_start}}{a positive integer between \eqn{1} and \eqn{nsteps} indicating the starting impulse response horizon period for the
   counterfactual behavior of the specified policy variable.}
 \item{\code{cfact_end}}{a positive integer between \code{cfact_start} and \eqn{nsteps} indicating the ending period for the counterfactual
   behavior of the specified policy variable.}
 \item{\code{cfact_path}}{a numeric vector of length \code{cfact_end-cfact_start+1} indicating the hypothetical path of the policy variable
  specified in the argument \code{policy_var}. This argument is only used when \code{cfact_type="fixed_path"}.}
}
\strong{Important:} If this is something else than \code{NULL}, it will change how the function behaves!}
}
\value{
Returns a class \code{'girf'} list with the GIRFs in the first
  element (\code{$girf_res}) and the used arguments the rest. The first
  element containing the GIRFs is a list with the \eqn{m}th element
  containing the point estimates for the GIRF in \code{$point_est} (the first
  element) and confidence intervals in \code{$conf_ints} (the second
  element). The first row is for the GIRF at impact \eqn{(n=0)}, the second
  for \eqn{n=1}, the third for \eqn{n=2}, and so on.

  The element \code{$all_girfs} is a list containing results from all the individual GIRFs
  obtained from the MC repetitions. Each element is for one shock and results are in
  array of the form \code{[horizon, variables, MC-repetitions]}.
}
\description{
\code{GIRF_int} in an INTERNAL function that estimates generalized impulse response function for
 structural STVAR models.
}
\details{
The "confidence bounds" \strong{do not} quantify uncertainty about the true parameter
  value but only the initial values (and possibly sign and size of the shock) within the given regime.
  If initial values are specified, confidence intervals won't be calculated. Note that if the bounds
  look weird in the figure produced by \code{plot.girf}, it is probably because the point estimate is not
  inside the bounds. In this case, increasing the argument \code{R2} usually fixes the issue.

  Note that if the argument \code{scale} is used, the scaled responses of
  the transition weights might be more than one in absolute value.

  If \code{weight_function="exogenous"}, exogenous transition weights used in
  the Monte Carlo simulations for the future sample paths of the process must
  the given in the argument \code{exo_weights}. The same weights are used as
  the transition weights across the Monte Carlo repetitions.

  If \code{use_data_shocks=TRUE}, the GIRF is estimated using all, or a subset of, the length p histories in the data
  as the initial values, and using the sign and size of the corresponding structural shock recovered from the fitted model.
  The subset of the length p histories are determined based in the settings given in the argument \code{data_girf_pars}.
  Note that the arguments \code{shock_size}  and \code{init_regime} are ignored if \code{use_data_shocks=TRUE}.
}
\references{
\itemize{
   \item Kilian L., Lütkepohl H. 2017. Structural Vector Autoregressive Analysis. 1st edition.
     \emph{Cambridge University Press}, Cambridge.
 }
}
\seealso{
\code{\link{GFEVD}}, \code{\link{linear_IRF}}, \code{\link{hist_decomp}}, \code{\link{cfact_hist}}, \code{\link{cfact_fore}},
 \code{\link{cfact_girf}}, \code{\link{fitSSTVAR}}
}
\keyword{internal}
