% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataReshape.R
\name{dataReshape}
\alias{dataReshape}
\title{Reshape longitudinal data}
\usage{
dataReshape(theData = NULL, numTime = NULL)
}
\arguments{
\item{theData}{a data frame containing longitudinal
data to which the model will be fit.}

\item{numTime}{number of time slices.}
}
\value{
A data frame representing longitudinal data with
two time slices, such that the first \code{n} data points contain the
relations that occur in the first two time slices
\code{t_0} and \code{t_1}. The next \code{n} data points contain the
relations that occur in time slices \code{t_1} and \code{t_2}.
The \code{i-th} subset of \code{n} data points contain the relations
in time slices \code{t_i-1} and \code{t_i}. The reshaped data can be used
as data input for function \code{\link{stableSpec}} when computing longitudinal data.
}
\description{
Reshape longitudinal data with \code{t} time slices into a longitudinal
data with two time slices.
}
\examples{
the_data <- longiData4V3T
num_time <- 3
reshaped_the_data <- dataReshape(the_data, num_time)
}
\author{
Ridho Rahmadi \email{r.rahmadi@cs.ru.nl}
}

