% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sincos.R
\name{sincos}
\alias{sincos}
\title{sin/cos pairs for modeling}
\usage{
sincos(x, period = 168/2/pi)
}
\arguments{
\item{x}{a vector}

\item{period}{a scalar, which x is scaled by}
}
\value{
a matrix containing a _sin and _cos column
}
\description{
Compute the sin and cos of x.
}
\examples{

data(sunspots)
lm(sunspots~sincos(time(sunspots), 5/pi))

}
\references{
\url{https://stackoverflow.com/questions/51874305/tuple-variable-in-r-regression-model/54393605#54393605}
}
\author{
\href{https://stackoverflow.com/users/986793/neal-fultz}{Neal Fultz}
}
