% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_parqual.R
\docType{methods}
\name{choice,ref_parqual-method}
\alias{choice,ref_parqual-method}
\title{Choice method for ref_parqual referential objects, internal use}
\usage{
\S4method{choice}{ref_parqual}(object,
  label = gettext("Choice of a sample characteristic", domain =
  "R-stacomiR"), nomassign = "ref_parqual", frameassign = "frame_par",
  is.enabled = TRUE)
}
\arguments{
\item{object}{An object of class \link{ref_parqual-class}}

\item{label}{The label to set in the frame}

\item{nomassign}{The name used when assigning the object ref_parqual to the \code{envir_stacomi} environment}

\item{frameassign}{The name of the gframe assigned to the user environment}

\item{is.enabled}{Is the frame enabled at launch.}
}
\description{
Choice method for ref_parqual referential objects, internal use
}
\note{
the choice method assigns an object of class ref_parqual named ref_parqual in the environment envir_stacomi
this method rewrites the method from ref_par, as it integrates a request of the possible values of qualitative parameters, hence the parameters,however it was redefined in ref_parqual
to load the possible values of qualitative parameters
}
\examples{
 
\dontrun{
 object=new("ref_parqual")
win=gwindow()
group=ggroup(container=win,horizontal=FALSE)
object<-charge(object)
choice(object)
}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\keyword{internal}
