% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_df.R
\docType{class}
\name{report_df-class}
\alias{report_df-class}
\alias{report_df}
\title{Report on fishway operation}
\description{
Fishways (DF) are of various nature, from very simple eel ladders fed by water discharged from the river,
to more complex fishways with levels adjusted by the opening of various gates and regulators. 
The objective of this class is to provide an assessment of the working status of a fishway throughout the year.
A number of fishes ascending a fishway has meaning only if we know that the fishway is operational, and that the counting 
operated on the fishway has remained operational.
In the database the operation of the fishway (DF) and counting device (DC) is agregated in one table (t_periodefonctdispositif_per).
The column  per_etat_fonctionnement indicates whether the fishway is operational (with a boolean) and the column per_tar_code indicates
the status of either the fishway or DC. In the database four types of operation are set,  "1"=normal operation,
"2"=Device stopped in normal operation (ie lift ascending, high tide...),
"3"="Stopped for maintenance or other problem",
"4"="Works but not fully operational, ie flow problem, flood, clogged with debris...",
"5"="Not known")
}
\section{Slots}{

\describe{
\item{\code{data}}{A data frame}

\item{\code{df}}{An object of class \code{ref_df-class}}

\item{\code{horodatedebut}}{An object of class \code{ref_horodate-class}}

\item{\code{horodatefin}}{An object of class \code{ref_horodate-class}}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("report_df")}.
}

\examples{
require(stacomiR)
stacomi(gr_interface=FALSE,
	login_window=FALSE,
	database_expected=FALSE)
## An example that will work with the database installed only
\dontrun{
  r_df=new("report_df")
  r_df<-choice_c(r_df,
	  1,
	  horodatedebut="2015-01-01",
	  horodatefin="2015-12-31",
	  silent=TRUE)
  Sys.setenv(TZ='GMT')
  # the times at Arzal are recorded continuously
  # they are converted to date when a time appears while the hour is changing
  # hence the following
  r_df<-connect(r_df)
}

data("r_df")
plot(r_df,plot.type="4")
# the following examples work but take a while to compute
\dontrun{
  plot(r_df,plot.type="1")
  plot(r_df,plot.type="2",main="A nice title")
  plot(r_df,plot.type="3",main="A nice title")	
}





}
\seealso{
Other report Objects: \code{\link{report_annual-class}},
  \code{\link{report_dc-class}},
  \code{\link{report_env-class}},
  \code{\link{report_ge_weight-class}},
  \code{\link{report_mig-class}},
  \code{\link{report_mig_char-class}},
  \code{\link{report_mig_env-class}},
  \code{\link{report_mig_interannual-class}},
  \code{\link{report_mig_mult-class}},
  \code{\link{report_sample_char-class}},
  \code{\link{report_sea_age-class}},
  \code{\link{report_silver_eel-class}},
  \code{\link{report_species-class}}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\concept{report Objects}
\keyword{classes}
