% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_dc.R
\name{plot,report_dc,missing-method}
\alias{plot,report_dc,missing-method}
\alias{plot.report_dc}
\title{Different plots for report_dc}
\usage{
\S4method{plot}{report_dc,missing}(
  x,
  plot.type = 1,
  silent = FALSE,
  main = NULL,
  color_type_oper = c(`Fonc normal` = "#76BEBE", `Arr ponctuel` = "#FF6700",
    `Arr maint` = "#9E0142", Dysfonc = "#EE1874", `Non connu` = "#999999"),
  color_etat = c(`TRUE` = "#0F313A", `FALSE` = "#CEB99A")
)
}
\arguments{
\item{x}{An object of class \link{report_dc-class}.}

\item{plot.type}{1 to 4, barplot, barchart, rectangle plot and box showing details of daily operation,
a plot with adjacent rectangles.}

\item{silent}{Stops displaying the messages default to FALSE}

\item{main}{The title of the graph, if NULL a default title will be plotted
with the number of the DF.}

\item{color_type_oper}{Named vector of color for the graph, must match type operation default to 
c("Fonc normal" = "#76BEBE",
 "Arr ponctuel" = "#FF6700",
 "Arr maint" = "#9E0142",
 "Dysfonc" = "#EE1874",
 "Non connu" = "#999999").}

\item{color_etat}{Named vector state value (must match the names "TRUE", "FALSE").}
}
\value{
Nothing but prints the different plots.
}
\description{
\itemize{
\item{plot.type=1}{A barplot of the operation time per month}
\item{plot.type=2}{Barchat giving the time per type of operation }
\item{plot.type=2}{Rectangle plots drawn along a line}
\item{plot.type=4}{Plots per day drawn over the period to show the operation of a df, days in x, hours in y}
	}
}
\note{
The program cuts periods which overlap between two month.
The splitting of different periods into month is
assigned to the \code{envir_stacomi} environment.
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
