% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequeteODBC.R
\name{connect,RequeteODBC-method}
\alias{connect,RequeteODBC-method}
\alias{connect.RequeteODBC}
\title{connect method loads a request to the database and returns either an error or a data.frame}
\usage{
\S4method{connect}{RequeteODBC}(object)
}
\arguments{
\item{object}{an object of class RequeteODBC}
}
\value{
An object of class RequeteODBC
}
\description{
connect method loads a request to the database and returns either an error or a data.frame
}
\note{
assign("showmerequest",1,envir=envir_stacomi) allows to print all queries passing on the class RequeteDB
}
\examples{
showClass("RequeteODBC")
\dontrun{
object=new("RequeteODBC")
object@open=TRUE
object@baseODBC=baseODBC
object@sql= "select * from t_lot_lot limit 100"
object<-connect(object)
odbcClose(object@connection)
odbcCloseAll()
  object=new("RequeteODBC")
  object@open=TRUE 
  ## this will leave the connection open, 
  ## by default it closes after the query is sent
  ## the following will work only if you have configured and ODBC link
  object@baseODBC=c("myODBCconnection","myusername","mypassword")
  object@sql= "select * from mytable limit 100"
  object<-connect(object)
  odbcClose(object@connection)
  envir_stacomi=new.env()
  ## While testing if you want to see the output of sometimes 
  ## complex queries generated by the program
  assign("showmerequest",1,envir_stacomi) 
  ## You can assign any values (here 1)
  ## just tests the existence of "showmerequest" in envir_stacomi
  object=new("RequeteODBC")
  object@baseODBC=c("myODBCconnection","myusername","mypassword")
  object@sql= "select * from mytable limit 100"
  object<-connect(object)
 ## the connection is already closed, the query is printed
}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
