% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamp.distance.r
\name{stamp.distance}
\alias{stamp.distance}
\title{stamp.distance}
\usage{
stamp.distance(stmp, dist.mode = "Centroid", group = FALSE)
}
\arguments{
\item{stmp}{a \code{sf} object generated from the \code{stamp} function.}

\item{dist.mode}{Character determining the method by which polygon distances are computed. If \code{"Centroid"}
then the centroid distance is calculated, if \code{"Hausdorff"} then the discrete Hausdorff distance
is calculated; see \code{Details}.}

\item{group}{logical indicating whether distances should be computed from the T1 polygon to each individual 
stamp event (\code{group = FALSE} -- the default), or whether T2 polygons should combined (through a spatial 
union) in order to compute the measure of distance for each stamp group (\code{group = TRUE})}
}
\value{
Appropriately named columns (e.g., \code{CENDIST} or \code{HAUSDIST}) in the stamp \code{sf}
 object. Distances are in meters.
}
\description{
The function \code{stamp.distance} can be used to compute various measures of distance 
 between polygon events and groups. In turn, distance measurements can be used to estimate the velocity
 of polygon movement.
}
\details{
\code{stamp.distance} computes distance between polygon sets based on either centroid or
   Hausdorff distance calculations. Centroid distance is simply the distance from the centroid
   of all T1 polygons (combined) to each stamp event (\code{group = FALSE}), or to the union of
   all T2 polygons within a group (\code{group = TRUE}), in the second case, all events within a group
   are given an identical distance value.\cr\cr
   The Hausdorff distance calculation uses the Hausdorff distance, as
   programmed in the function \code{st_distance}. A value of \code{par = 0.1} is used
   to increase the precision of this measurement -- see \code{help(st_distance)}. The returned distance
   is then the Hausdorff distance of all T1 polygons (combined) to each stamp event (\code{group = FALSE}),
   or to the union of all T2 polygons within a group (\code{group = TRUE}), in the second case, all events 
   within a group are given an identical distance value.
   All distance calculations are computed in meters using the geographical projection WGS84.
}
\references{
Hausdorff Distance: \url{https://en.wikipedia.org/wiki/Hausdorff_distance}
}
\seealso{
stamp stamp.direction
}
\keyword{stamp}
