% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_get_dimension.R
\name{get_dimension}
\alias{get_dimension}
\alias{get_dimension.star_schema}
\title{Get dimension}
\usage{
get_dimension(st, name)

\method{get_dimension}{star_schema}(st, name)
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{name}{A string, name of the dimension.}
}
\value{
A \code{dimension_table} object.
}
\description{
Get a dimension of a star schema given its name.
}
\details{
Role dimensions can be obtained but not role playing dimensions. Role
dimensions get their instances of role playing dimensions.
}
\examples{
library(tidyr)

d <- st_mrs_age \%>\%
  get_dimension("when")

}
\seealso{


Other data cleaning functions: 
\code{\link{get_conformed_dimension_names}()},
\code{\link{get_conformed_dimension}()},
\code{\link{get_dimension_names}()},
\code{\link{match_records}()},
\code{\link{modify_conformed_dimension_records}()},
\code{\link{modify_dimension_records}()},
\code{\link{record_update_set}()},
\code{\link{update_record}()},
\code{\link{update_selection_general}()},
\code{\link{update_selection}()}
}
\concept{data cleaning functions}
