% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLE.matching.R
\name{MLE.matching}
\alias{MLE.matching}
\title{Maximum likelihood estimator (MLE) in the generalised matching distribution}
\usage{
MLE.matching(
  x,
  size,
  CI.method = "asymptotic",
  conf.level = 0.95,
  bootstrap.sims = 10^3
)
}
\arguments{
\item{x}{A vector of numeric values to be used as arguments for the mass function}

\item{size}{The size parameter for the generalised matching distribution (number of objects to match)}

\item{CI.method}{The method used to compute the confidence interval ('asymptotic' or 'bootstrap')}

\item{conf.level}{The width of the CI}

\item{bootstrap.sims}{The number of bootstrap simulations used in the bootstrap confidence interval}
}
\value{
If all inputs are correctly specified (i.e., parameters are in allowable range) then the output will
be a list of outputs for the MLE
}
\description{
\code{MLE.matching} returns the maximum likelihood estimator (MLE) for the data.
}
\details{
This function computes the maximum likelihood estimator (MLE) from data consisting of IID samples
from the generalised matching distribution.  Further details on the distribution can be found in 
the following paper:
}
\examples{

X <- rmatching(20, 5, prob=.1)

# For comparison
# MASS::fitdistr(X, dmatching, start=list(prob=.5), size=5, lower=c(prob=0), upper=c(prob=1))

MLE.matching(X, 5)

}
\references{
O'Neill, B. (2021) A generalised matching distribution for the problem of coincidences.
}
