% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{fraiman}
\alias{fraiman}
\title{Daniel Fraiman and Ricardo Fraiman test for network differences between 
groups with an analysis of variance test (ANOVA).}
\usage{
fraiman(g, maxPer = 300, alpha = 0.05, printResult = FALSE)
}
\arguments{
\item{g}{the undirected graphs to be compared. Must be a list of lists of 
igraph objects or a list of lists of adjacency matrices.}

\item{maxPer}{integer indicating the number of bootstrap resamples 
(default is 300).}

\item{alpha}{the significance level for the test (default is 0.05).}

\item{printResult}{logical indicating if the test must print the result 
(default is FALSE).}
}
\value{
A list containing:
\item{test_stats}{the value of the test.}
\item{p_value}{the p-value of the test.}
\item{bootstrap_samples}{The test distrition on the bootstrap resamples.}
}
\description{
Given a list of graphs, the test verifies if all the subpopulations have the 
same mean network,
under the alternative that at least one subpopulation has a different mean 
network.
}
\examples{
require(igraph)
set.seed(42)

## test under H0
a <- b <- d <- list()
for(i in 1:10){
  a[[i]] <- erdos.renyi.game(50,0.5)
  b[[i]] <- erdos.renyi.game(50,0.5)
}
d <- list(a,b)
k <- fraiman(d, printResult = TRUE)

## test under H1
a <- b <- d <- list()
for(i in 1:10){
  a[[i]] <- erdos.renyi.game(50,0.5)
  b[[i]] <- erdos.renyi.game(50,0.6)
}
d <- list(a,b)
k <- fraiman(d, printResult = TRUE)

}
\references{
Fraiman, Daniel, and Ricardo Fraiman. "An ANOVA approach for statistical 
comparisons of brain networks", 
https://www.nature.com/articles/s41598-018-23152-5
}
