% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state-panel.R
\name{state_panel}
\alias{state_panel}
\title{Create state panel data}
\usage{
state_panel(start, end, by = "year", partial = "exact", useGW = TRUE)
}
\arguments{
\item{start}{Beginning date for data}

\item{end}{End date for data}

\item{by}{Temporal resolution, "year", "month", or "day".}

\item{partial}{Option for how to handle edge cases where a state is independent
for only part of a time period (year, month, etc.). Options include
\code{"exact"}, and \code{"any"}. See details.}

\item{useGW}{Use Gleditsch & Ward statelist or Correlates of War state system
membership list.}
}
\description{
Create panel data consisting of independent states in the international system.
}
\details{
The partial option determines how to handle instances where a country gains
or loses independence during a time period specified in the by option:

\itemize{
    \item{"exact": the exact date in start is used for filtering}
    \item{"any": a state-period is included if the state was independent at
                 any point in that period.}
}
}
\examples{
# Basic usage with full option set specified:
gwlist  <- state_panel("1991-01-01", "2015-01-01", by = "year",
                       partial = "any", useGW = TRUE)
head(gwlist, 3)
cowlist <- state_panel("1991-01-01", "2015-01-01", by = "year",
                       partial = "any", useGW = FALSE)
head(cowlist, 3)

# For yearly data, a proper date is not needed, and by = "year" and
# partial = "any" are inferred.
gwlist <- state_panel(1990, 1995)
sfind(265, list = "GW")
265 \%in\% gwlist$gwcode

# Partials
# Focus on South Sudan--is there a record for 2011, first year of indendence?
data(gwstates)
dplyr::filter(gwstates, gwcode==626)
# No 2011 because SSD was not indpendent on January 1st 2011
x <- state_panel("2011-01-01", "2013-01-01", by = "year", partial = "exact")
dplyr::filter(x, gwcode==626)
# Includes 2011 because 12-31 date is used for filtering
x <- state_panel("2011-12-31", "2013-12-31", by = "year", partial = "exact")
dplyr::filter(x, gwcode==626)
# Includes 2011 because partial = "any"
x <- state_panel("2011-01-01", "2013-01-01", by = "year", partial = "any")
dplyr::filter(x, gwcode==626)

}
