/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.SampleIds;
import beagleutil.Samples;
import blbutil.SampleFileIt;
import haplotype.HapPair;
import haplotype.RefHapPairs;
import haplotype.SampleHapPairs;
import haplotype.WrappedHapPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import vcf.BasicGL;
import vcf.Data;
import vcf.GL;
import vcf.Markers;
import vcf.RefGL;
import vcf.RestrictedVcfWindow;
import vcf.VcfEmission;
import vcf.VcfWindow;

public class AllData
implements Data {
    private int window = 0;
    private VcfEmission[] refData;
    private SampleHapPairs refSampleHapPairs;
    private GL refEmissions;
    private VcfEmission[] targetData;
    private int[] refIndices;
    private int[] targetIndices;
    private GL targetEmissions;
    private final Samples allSamples;
    private final List<HapPair> refHapPairs;
    private final List<HapPair> targetRefHapPairs;
    private final VcfWindow refWindow;
    private final RestrictedVcfWindow targetWindow;

    public static AllData allData(SampleFileIt<VcfEmission> sampleFileIt, SampleFileIt<? extends VcfEmission> sampleFileIt2) {
        if (sampleFileIt.samples().nSamples() == 0 && sampleFileIt2.samples().nSamples() == 0) {
            throw new IllegalArgumentException("nSamples==0");
        }
        VcfWindow vcfWindow = new VcfWindow(sampleFileIt);
        RestrictedVcfWindow restrictedVcfWindow = new RestrictedVcfWindow(sampleFileIt2);
        return new AllData(vcfWindow, restrictedVcfWindow);
    }

    private AllData(VcfWindow vcfWindow, RestrictedVcfWindow restrictedVcfWindow) {
        AllData.checkSampleOverlap(vcfWindow.samples(), restrictedVcfWindow.samples());
        this.refWindow = vcfWindow;
        this.targetWindow = restrictedVcfWindow;
        this.refData = new VcfEmission[0];
        this.refSampleHapPairs = null;
        this.refEmissions = new RefGL(vcfWindow.samples(), this.refData);
        this.targetData = new VcfEmission[0];
        this.refIndices = new int[0];
        this.targetIndices = new int[0];
        this.targetEmissions = new BasicGL(restrictedVcfWindow.samples(), this.targetData);
        this.allSamples = AllData.allSamples(vcfWindow.samples(), restrictedVcfWindow.samples());
        this.refHapPairs = new ArrayList<HapPair>(0);
        this.targetRefHapPairs = new ArrayList<HapPair>(0);
    }

    private static Samples allSamples(Samples samples, Samples samples2) {
        int n;
        int n2 = samples.nSamples();
        int n3 = samples2.nSamples();
        int[] nArray = new int[n2 + n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = samples2.idIndex(n);
        }
        for (n = 0; n < n2; ++n) {
            nArray[n3 + n] = samples.idIndex(n);
        }
        return new Samples(nArray);
    }

    private static void checkSampleOverlap(Samples samples, Samples samples2) {
        int n;
        int n2 = samples.nSamples();
        int n3 = samples2.nSamples();
        int n4 = n2 + n3;
        int[] nArray = new int[n4];
        for (n = 0; n < n2; ++n) {
            nArray[n] = samples.idIndex(n);
        }
        for (n = 0; n < n3; ++n) {
            nArray[n2 + n] = samples2.idIndex(n);
        }
        Arrays.sort(nArray);
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n - 1] != nArray[n]) continue;
            String string = "Overlap between reference and non-reference samples: " + SampleIds.instance().id(nArray[n - 1]);
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public boolean lastWindowOnChrom() {
        return this.refWindow.lastWindowOnChrom();
    }

    @Override
    public boolean canAdvanceWindow() {
        return this.refWindow.canAdvanceWindow();
    }

    @Override
    public void advanceWindow(int n, int n2) {
        Samples samples = this.refWindow.samples();
        this.refData = this.refWindow.advanceWindow(n, n2);
        this.refEmissions = new RefGL(samples, this.refData);
        this.refSampleHapPairs = new RefHapPairs(this.refEmissions.markers(), samples, this.refData);
        this.targetData = this.targetWindow.advanceWindow(this.refEmissions.markers());
        this.refIndices = AllData.refIndices(this.targetData);
        this.targetIndices = AllData.targetIndices(this.targetData);
        this.targetEmissions = AllData.targetEmissions(this.targetWindow.samples(), this.targetData, this.refIndices);
        ++this.window;
        this.setRefHaplotypes(this.refEmissions.markers(), this.refData);
        this.setTargetRefHaplotypes(this.targetEmissions.markers(), this.refData, this.refIndices);
    }

    @Override
    public int window() {
        return this.window;
    }

    private static int[] refIndices(VcfEmission[] vcfEmissionArray) {
        int n = 0;
        for (VcfEmission vcfEmission : vcfEmissionArray) {
            if (vcfEmission == null) continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < vcfEmissionArray.length; ++i) {
            if (vcfEmissionArray[i] == null) continue;
            nArray[n2++] = i;
        }
        if (n2 != nArray.length) {
            throw new IllegalStateException("vma modification detected");
        }
        return nArray;
    }

    private static int[] targetIndices(VcfEmission[] vcfEmissionArray) {
        int[] nArray = new int[vcfEmissionArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = vcfEmissionArray[i] != null ? n++ : -1;
        }
        return nArray;
    }

    private static GL targetEmissions(Samples samples, VcfEmission[] vcfEmissionArray, int[] nArray) {
        VcfEmission[] vcfEmissionArray2 = new VcfEmission[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            vcfEmissionArray2[i] = vcfEmissionArray[nArray[i]];
        }
        return new BasicGL(samples, vcfEmissionArray2);
    }

    private void setRefHaplotypes(Markers markers, VcfEmission[] vcfEmissionArray) {
        this.refHapPairs.clear();
        RefHapPairs refHapPairs = new RefHapPairs(markers, this.refWindow.samples(), vcfEmissionArray);
        int n = refHapPairs.nSamples();
        for (int i = 0; i < n; ++i) {
            this.refHapPairs.add(new WrappedHapPair(refHapPairs, i));
        }
    }

    private void setTargetRefHaplotypes(Markers markers, VcfEmission[] vcfEmissionArray, int[] nArray) {
        assert (markers.nMarkers() == nArray.length);
        this.targetRefHapPairs.clear();
        VcfEmission[] vcfEmissionArray2 = new VcfEmission[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            vcfEmissionArray2[i] = vcfEmissionArray[nArray[i]];
        }
        RefHapPairs refHapPairs = new RefHapPairs(markers, this.refWindow.samples(), vcfEmissionArray2);
        int n = refHapPairs.nSamples();
        for (int i = 0; i < n; ++i) {
            this.targetRefHapPairs.add(new WrappedHapPair(refHapPairs, i));
        }
    }

    @Override
    public int targetOverlap() {
        return this.targetWindow.overlap();
    }

    @Override
    public int overlap() {
        return this.refWindow.overlap();
    }

    @Override
    public int nTargetMarkers() {
        return this.targetEmissions.markers().nMarkers();
    }

    @Override
    public int nTargetMarkersSoFar() {
        return this.targetWindow.cumMarkerCnt();
    }

    @Override
    public Markers targetMarkers() {
        return this.targetEmissions.markers();
    }

    @Override
    public int nMarkers() {
        return this.refEmissions.nMarkers();
    }

    @Override
    public int nMarkersSoFar() {
        return this.refWindow.cumMarkerCnt();
    }

    @Override
    public Markers markers() {
        return this.refEmissions.markers();
    }

    @Override
    public int targetMarkerIndex(int n) {
        return this.targetIndices[n];
    }

    @Override
    public int markerIndex(int n) {
        return this.refIndices[n];
    }

    @Override
    public int nTargetSamples() {
        return this.targetEmissions.nSamples();
    }

    @Override
    public Samples targetSamples() {
        return this.targetEmissions.samples();
    }

    @Override
    public int nRefSamples() {
        return this.refWindow.nSamples();
    }

    @Override
    public Samples refSamples() {
        return this.refWindow.samples();
    }

    @Override
    public int nAllSamples() {
        return this.allSamples.nSamples();
    }

    @Override
    public Samples allSamples() {
        return this.allSamples;
    }

    @Override
    public GL targetGL() {
        return this.targetEmissions;
    }

    @Override
    public List<HapPair> restrictedRefHapPairs() {
        return new ArrayList<HapPair>(this.targetRefHapPairs);
    }

    @Override
    public List<HapPair> refHapPairs() {
        return new ArrayList<HapPair>(this.refHapPairs);
    }

    @Override
    public SampleHapPairs refSampleHapPairs() {
        return this.refSampleHapPairs;
    }

    @Override
    public void close() {
        this.refWindow.close();
        this.targetWindow.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(this.getClass().toString());
        return stringBuilder.toString();
    }
}

